/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.indxp.core;

import de.admadic.calculator.modules.indxp.core.DataEvent;
import de.admadic.calculator.modules.indxp.core.DataEventDispatcher;
import de.admadic.calculator.modules.indxp.core.DataEventListener;
import de.admadic.calculator.modules.indxp.core.DataEventServer;
import de.admadic.calculator.modules.indxp.core.ExpResults;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpResultsTableModel
extends AbstractTableModel
implements DataEventListener {
    private static final long serialVersionUID = 1L;
    ArrayList<ExpResults> data;
    boolean locked;
    DataEventDispatcher dataEventDispatcher;
    DataEventServer dataEventServer;

    public void setData(ArrayList<ExpResults> arrayList) {
        this.data = arrayList;
    }

    public void setDataEventDispatcher(DataEventDispatcher dataEventDispatcher) {
        this.dataEventDispatcher = dataEventDispatcher;
    }

    public void setDataEventServer(DataEventServer dataEventServer) {
        this.dataEventServer = dataEventServer;
    }

    @Override
    public int getRowCount() {
        if (this.data != null) {
            return this.data.size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        if (this.data == null) {
            return 0;
        }
        if (this.data.size() < 1) {
            return 1;
        }
        ExpResults expResults = this.data.get(0);
        return expResults.getReplicateCount() + 2;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.data == null) {
            return null;
        }
        ExpResults expResults = this.data.get(n);
        if (n2 < expResults.getReplicateCount()) {
            return expResults.getResult(n2);
        }
        if (n2 == expResults.getReplicateCount()) {
            return expResults.getYAvg();
        }
        if (n2 == expResults.getReplicateCount() + 1) {
            return expResults.getSigma();
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return Double.class;
    }

    @Override
    public String getColumnName(int n) {
        if (this.data == null) {
            return null;
        }
        if (this.data.size() < 1) {
            return "Replicates";
        }
        ExpResults expResults = this.data.get(0);
        if (n < expResults.getReplicateCount()) {
            return "y" + (n + 1);
        }
        if (n == expResults.getReplicateCount()) {
            return "y#";
        }
        if (n == expResults.getReplicateCount() + 1) {
            return "s*";
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.isLocked()) {
            return false;
        }
        ExpResults expResults = this.data.get(n);
        return n2 < expResults.getReplicateCount();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ExpResults expResults = this.data.get(n);
        if (n2 < expResults.getReplicateCount()) {
            expResults.setResult(n2, (Double)object);
            if (this.dataEventDispatcher != null) {
                this.dataEventDispatcher.notifyEvent(this, 1024);
            }
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
        this.fireTableDataChanged();
    }

    @Override
    public void dataEventSignalled(DataEvent dataEvent) {
        if (dataEvent.getSource() == this) {
            return;
        }
        if ((dataEvent.getMask() & 0x40) != 0) {
            this.fireTableStructureChanged();
        }
        if ((dataEvent.getMask() & 0x80) != 0) {
            this.fireTableDataChanged();
        }
    }
}

