/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.indxp;

import de.admadic.calculator.appctx.AppEvent;
import de.admadic.calculator.appctx.AppEventListener;
import de.admadic.calculator.appctx.CancelPhaseException;
import de.admadic.calculator.appctx.IAppContext;
import de.admadic.calculator.appmod.IModule;
import de.admadic.calculator.appmod.ModuleDesc;
import de.admadic.calculator.modules.indxp.InDXpActions;
import de.admadic.calculator.modules.indxp.InDXpCfg;
import de.admadic.calculator.modules.indxp.InDXpItf;
import de.admadic.calculator.modules.indxp.InDXpLicense;
import de.admadic.calculator.modules.indxp.ui.InDXpFrame;
import de.admadic.cfg.Cfg;
import de.admadic.license.ModuleLicense;
import de.admadic.license.ModuleLicenseWatchDog;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class InDXpModule
implements IModule,
AppEventListener,
ComponentListener,
InDXpItf {
    ModuleDesc moduleDesc;
    InDXpFrame frame;
    IAppContext appContext;
    Cfg cfg;
    InDXpCfg modCfg;
    InDXpActions actions;
    InDXpLicense moduleLicense;
    ModuleLicenseWatchDog moduleLicenseWatchDog;

    public InDXpModule() {
        this.createModuleDesc();
    }

    private void createModuleDesc() {
        this.moduleDesc = new ModuleDesc();
        this.moduleDesc.setImplDetails("admaDIC", "InDXp", "1.0.0");
        this.moduleDesc.setSpecDetails("admaDIC", "InDXp", "1.0.0");
        this.moduleDesc.setCfgName("InDXp");
    }

    public void initialize(IAppContext iAppContext) {
        this.appContext = iAppContext;
        this.cfg = iAppContext.getCfg();
        this.actions = new InDXpActions();
        this.modCfg = new InDXpCfg(this.cfg);
        this.modCfg.setPrefix(iAppContext.getCfgModulesPrefix());
        this.modCfg.checkPrevCfg();
        this.initActions();
        iAppContext.addAppListener((AppEventListener)this);
    }

    protected void initActions() {
        this.actions.initialize(this);
    }

    public ModuleDesc getModuleDesc() {
        return this.moduleDesc;
    }

    public JMenu createModuleMenu() {
        JMenu jMenu = new JMenu("InDXp");
        if (this.actions != null && this.actions.getActions() != null) {
            for (int i = 1; i < this.actions.getActions().size(); ++i) {
                JMenuItem jMenuItem = new JMenuItem(this.actions.getActions().get(i));
                jMenu.add(jMenuItem);
            }
        }
        return jMenu;
    }

    public Action[] getActions() {
        return this.actions.getActionArray();
    }

    public void processPhase(AppEvent appEvent) throws CancelPhaseException {
        switch (appEvent.getPhase()) {
            case 1: {
                break;
            }
            case 2: {
                this.doInitFrame();
                break;
            }
            case 3: {
                this.doShowFrame();
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.checkExit();
                break;
            }
            case 7: {
                this.doExit();
                break;
            }
        }
    }

    private void doInitFrame() {
        this.frame = new InDXpFrame(this.modCfg, this.actions, this.appContext);
        if (this.appContext != null && this.appContext.getLafManager() != null) {
            this.appContext.getLafManager().addComponent((Component)this.frame);
        }
        this.frame.addComponentListener(this);
    }

    private void doShowFrame() {
        Rectangle rectangle = this.modCfg.getPos();
        if (rectangle != null) {
            this.frame.setBounds(rectangle);
        }
        boolean bl = this.modCfg.getShow(true);
        this.frame.setVisible(bl);
    }

    private void checkExit() throws CancelPhaseException {
        if (this.frame.getData().isDirty() && !this.frame.checkSave()) {
            throw new CancelPhaseException("User prohibited exit");
        }
    }

    private void doExit() {
        if (this.moduleLicense != null) {
            this.moduleLicenseWatchDog.shutdown();
            this.moduleLicense.shutdown();
            this.moduleLicense = null;
            this.moduleLicenseWatchDog = null;
        }
        this.frame.dispose();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.modCfg.putPos(this.frame.getBounds());
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.modCfg.putPos(this.frame.getBounds());
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.modCfg.putPos(this.frame.getBounds());
        this.modCfg.putShow(this.frame.isVisible());
        if (this.moduleLicense == null) {
            this.moduleLicense = new InDXpLicense(this.frame, this.modCfg);
            this.moduleLicenseWatchDog = new ModuleLicenseWatchDog((JFrame)this.frame, (ModuleLicense)this.moduleLicense);
        }
        this.moduleLicense.licenseProcess();
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.modCfg.putShow(this.frame.isVisible());
    }

    public void cmdShow() {
        if (!this.frame.isVisible()) {
            this.frame.setVisible(true);
        }
    }

    public void cmdHide() {
        if (this.frame.isVisible()) {
            this.frame.setVisible(false);
        }
    }

    public void cmdSingleButton() {
        this.frame.setVisible(!this.frame.isVisible());
    }

    public void cmdSettings() {
        this.frame.doToolsOptions();
    }

    public void cmdRegister() {
        this.moduleLicense.showRegistrationDialog();
    }

    public void cmdAbout() {
        this.frame.doHelpAbout();
    }
}

