/* Bounce.h
 */

#include <stdio.h>
#include <stdlib.h>
#include "simc.h"

/*----------------------------------------------------------*/
typedef struct
{
  double Height,
         Velocity;
}
Bounce_Data;

int Bounce_Process( Bounce_Data *);
int Bounce_Equation( int, Bounce_Data *, Bounce_Data *, double);
int Print_Process( Bounce_Data *);

double Simulation_Duration = 10.0,
       Print_Interval      =  0.1;

#define _Bounce_Factor        0.9
#define _Gravity             10.0
#define _Friction_Factor      0.1

/*----------------------------------------------------------*/

/*----------------------------------------------------------*/
void main( void)
{
  Bounce_Data *D;

  Create( D, Bounce_Data);
  D->Height       =  10.0;
  D->Velocity     =   0.0;

  EvSchedule( Print_Process,  D, 0.0);
  EvSchedule( Bounce_Process, D, 0.0);

  EvSimulate();
}
/*----------------------------------------------------------*/



/*----------------------------------------------------------*/
int Bounce_Process( Bounce_Data *D)
{
  ContinuousBegin;

  ContinuousWait( 2, D, Bounce_Equation);

  if( D->Height   < 0.0
  &&  D->Velocity < 0.0 )
    D->Velocity = - _Bounce_Factor * D->Velocity;

  if( EvClock() > Simulation_Duration) return( 0);

  ContinuousEnd;
}
/*----------------------------------------------------------*/



/*----------------------------------------------------------*/
int Bounce_Equation( int          N,
                     Bounce_Data *V,
                     Bounce_Data *dV,
                     double       T)
{
  dV->Height   = V->Velocity;
  dV->Velocity = - _Gravity - _Friction_Factor* V->Velocity;

  return( 0);
}
/*----------------------------------------------------------*/



/*----------------------------------------------------------*/
int Print_Process( Bounce_Data *D)
{
  ProcessBegin;
  while( EvClock() < Simulation_Duration)
  {
    printf( "%lf %lf \n", EvClock(), D->Height);
    ProcessWait( Print_Interval);
  }
  ProcessEnd;
}
/*----------------------------------------------------------*/
