#############################################################################
#
#                       Copyright (C) 1994 SciTech Software
#                               All rights reserved.
#
# Descripton:   Generic DMAKE startup makefile definitions file. Assumes
#               that the SCITECH environment variable has been set to point
#               to where all our stuff is installed. You should not need
#               to change anything in this file.
#
#               DJGPP port of GNU C/C++ to DOS with go32 DOS Extender.
#
# $Id: dj32.mk 1.4 1995/09/26 12:37:11 kjb release $
#
#############################################################################

# Disable warnings for macros redefined here that were given
# on the command line.
__.SILENT       := $(.SILENT)
.SILENT         := yes

# File suffix definitions
   L            := .a     # Libraries
   E            := .exe   # Executables
   O            := .o     # Objects
   A            := .asm   # Assembler sources
   P            := .cpp   # C++ sources

# Import enivornment variables that we use
TMPDIR := $(ROOTDIR)/tmp
.IMPORT .IGNORE : TMPDIR COMSPEC INCLUDE LIB SCITECH DBG OPT OPT_SIZE SHW BETA FPU

# We use the MSDOS shell at all times
   SHELL        := $(COMSPEC)
   GROUPSHELL   := $(SHELL)
   SHELLFLAGS   := $(SWITCHAR)c
   GROUPFLAGS   := $(SHELLFLAGS)
   SHELLMETAS   := *"?<>
   GROUPSUFFIX  := .bat
   DIRSEPSTR    := \\
   DIVFILE       = $(TMPFILE:s,/,\)

# Default commands for compiling, assembling linking and archiving
   CC           := gcc      # C-compiler and flags
   CFLAGS       := -Wall
   AS           := tasm     # Assembler and flags
   ASFLAGS      := /mx /m /D__FLAT__ /i$(SCITECH)\INCLUDE
   LD           := dj_ld    # Loader and flags
   LDFLAGS       = $(CFLAGS)
   LIB          := ar       # Librarian
   LIBFLAGS     := rs

# Optionally turn on debugging information
.IF $(DBG)
   CFLAGS       += -g       # Turn on debugging for C compiler
   ASFLAGS      += /zi      # Turn on debugging for assembler
.ELSE
   ASFLAGS      += /q       # Suppress object records not needed for linking
.END

# Optionally turn on optimisations
.IF $(OPT)
   CFLAGS       += -O2
.ELIF $(OPT_SIZE)
   CFLAGS       += -O1
.END

# Optionally turn on direct i387 FPU instructions

.IF $(FPU)
   CFLAGS       += -DFPU387
   ASFLAGS      += -DFPU387
.END

# Optionally compile a shareware version of a product
.IF $(SHW)
   LIB_DIR      := LIBSW
   CFLAGS       += -DSHAREWARE
.ELSE
   LIB_DIR      := LIB
.END

# Optionally compile a beta release version of a product
.IF $(BETA)
   CFLAGS       += -DBETA
   ASFLAGS      += -DBETA
.END

# DOS extender dependant flags
   DX_CFLAGS    += -DDJGPP
   DX_ASFLAGS   += -DDJGPP

# Define where to install library files
   LIB_DEST     := $(SCITECH)\$(LIB_DIR)\DOS32\DJ

# Place to look for PMODE library files

.IF $(MK_PMODE)
PMLIB           := go32\pmode.a
.END

# Definition of $(MAKE) macro for recursive makes.
   MAKE = $(MAKECMD) $(MFLAGS)

# Macro to install a library file
   INSTALL      := cp

# Implicit generation rules for making object files
   %$O: %.c ; $(CC) $(CFLAGS) -c $<
   %$O: %$P ; $(CC) $(CFLAGS) -c $<
   .SWAP %$O: %$A ;
@[
    $(AS) $(ASFLAGS) $(<:s,/,\)
    emxaout -u $*.obj
]

# Implicit rule for building a library file using response file
   %$L:      ; $(LIB) $(LIBFLAGS) $@ @$(mktmp $?\n)

# Implicit rule for building an executable file using response file
#   %$E:      ; $(LD) $(LDFLAGS) $@ @$(mktmp $(&:s/\/\\) $(PMLIB) $(EXELIBS) -lm -lpc)
   %$E:      ; $(LD) $(LDFLAGS) $@ $(&:s/\/\\) $(PMLIB) $(EXELIBS) -lm -lpc

# DMAKE uses this recipe to remove intermediate targets
.REMOVE :; $(RM) -f $<

# Turn warnings back to previous setting.
.SILENT := $(__.SILENT)

# We dont use TABS in our makefiles
.NOTABS         := yes

# Define where the local include files are kept for dependencies in
# makefiles after this file is included.

RCSINC :=  $(SCITECH)\INCLUDE

