/*
 * Read and display information from the header record for a DOS "EXE" file.
 *
 * Compile with: cc showexe -fop
 */
#include <stdio.h>

struct EXEheader {
	char sig1;
	char sig2;
	unsigned largest_block;
	unsigned number_of_blocks;
	unsigned num_reloc_table;
	unsigned size_of_header;
	unsigned min_add_ram;
	unsigned max_add_ram;
	unsigned ss_offset;
	unsigned initial_sp;
	unsigned checksum;
	unsigned initial_ip;
	unsigned cs_offset;
	unsigned first_rel_item; } ;

main(argc, argv)
	int argc;
	char *argv[];
{
	struct EXEheader header;
	FILE *fp;

	if(argc < 2)
		abort("Use: showexe <filename>\n");

	fp = fopen(argv[1], "rvqb");
	fread(header, sizeof(header), fp);
	fclose(fp);
	printf("Signature: '%c%c'\n", header.sig1, header.sig2);
	printf("Last block size: %u\n", header.largest_block);
	printf("Number of blocks: %u\n", header.number_of_blocks);
	printf("Number of items in relocation table: %u\n", header.num_reloc_table);
	printf("Size of header (in paragraphs): %u\n", header.size_of_header);
	printf("MIN additional RAM required: %u\n", header.min_add_ram);
	printf("MAX additional RAM required: %u\n", header.max_add_ram);
	printf("Offset to SS (in paragraphs): %u\n", header.ss_offset);
	printf("Initial stack pointer: $%04x\n", header.initial_sp);
	printf("Checksum: %04x\n", header.checksum);
	printf("Initial Instruction Pointer: $%04x\n", header.initial_ip);
	printf("Offset to CS (in paragraphs): %u\n", header.cs_offset);
	printf("Offset of first relocatable item: $%04x\n", header.first_rel_item);
}
