/*
 * A simple (but useful) hexidecimal/octal file dump utility
 *
 * Copyright 1990-1994 Dave Dunfield
 * All rights reserved.
 *
 * Permission granted for personal (non-commercial) use only.
 *
 * Compile command: cc dump -fop
 */
#include <stdio.h>

char bpause = 0, fpause = 0, octal = 0;
int lsize = 16;

/*
 * Main program - dump file contents
 */
main(argc, argv)
	int argc;
	int *argv[];
{
	int i, size, addr, filecount;
	char c, buffer[256], *ptr, *ptr1, *fnames[25];
	char name[13];
	int sizeh, sizel, attrs, time, date;
	FILE *fp;

	if(argc < 2)
		abort("\nUse: dump <filename*> -p -f -o\n\nCopyright 1990-1994 Dave Dunfield\nAll rights reserved.\n");

	/* Evaluate arguments & store filenames */
	filecount = 0;
	for(i=1; i < argc; ++i) {
		switch(*argv[i]) {
			case 'p-' :		/* Pause between blocks */
				bpause = -1;
				break;
			case 'f-' :		/* Pause between files */
				fpause = -1;
				break;
			case 'o-' :		/* Octal output */
				octal = -1;
				lsize = 8;
				break;
			default:
				fnames[filecount++] = argv[i]; } }

	/* Step through filenames & display any matching files */
	for(i = 0; i < filecount; ++i) {
		if(find_first(ptr = ptr1 = fnames[i], -1, name, &sizeh, &sizel, &attrs, &time, &date))
			fprintf(stderr,"Not found: %s\n", ptr);
		else {
			/* Determine directory path */
			while(c = *ptr++)
				if((c == '\\') || (c == ':'))
					ptr1 = ptr;
			*ptr1 = 0;
			do {
				concat(buffer, fnames[i], name);	/* Create full pathname */
				if(!(fp = fopen(buffer, "rbv")))
					continue;
				if(fpause == 0x0f) {
					printf("Press <return> for dump of '%s'...", buffer);
					fgets(buffer, 256, stdin); }
				else
					printf("Dump of '%s'\n", buffer);
				fpause &= 0x0f;
				addr = 0;
				do {
					putc('\n', stdout);
					size = fread(buffer, 256, fp);
					dump(buffer, size, addr);
					if(bpause && (size == 256)) {
						printf("Press <return> for next page...");
						fgets(buffer, 256, stdin); }
					addr += 256; }
				while(size == 256);
				fclose(fp);
				putc('\n', stdout); }
			while(!find_next(name, &sizeh, &sizel, &attrs, &time, &date)); } }
}

/*
 * Dump a buffer of memory with the specified address & size
 */
dump(buffer, size, addr)
	unsigned char *buffer;
	unsigned size, addr;
{
	unsigned i, j, c;

	for(i=0; i < size; i += lsize) {
		printf(octal ? "%06o " : "%04x ", addr+i);
		for(j=0; j < lsize; ++j) {						/* Display HEX */
			if(!(j & 0x03))
				putc(' ', stdout);
			if((i+j) < size) {
				printf(octal ? "%03o " : "%02x ", buffer[j]); }
			else
				fputs(octal ? "    " : "   ", stdout); }
		putc(' ', stdout);
		for(j=0; (j < lsize) && ((i+j) < size); ++j) {	/* Display ASCII */
			c = *buffer++;
			putc(((c >= ' ') && (c < 0x7f)) ? c : '.', stdout); }
		putc('\n', stdout); }
}
