;Listing 3	Scheduling Algorithm (Assembly Subroutines)
;(C) Copyright 1986 Ken Berry.
;All rights reserved.
;Copies may be made for non-commercial, private use only.


	  include tele.mac ; system definitions (listing 2)

	  extrn t_astrm:byte ; application task termination flag
	  extrn t_rtmark:near ; update pseudo time accumulator
	  extrn t__krnl:near ; security kernel

	  public sys_task ; current task pointer
	  public sys_tsch ; task scheduling table pointer
	  public sys_ilck ; system task interlock
	  public sys_asbs ; application stack base
	  public sys_dgrp ; data segment storage
	  public sys_ssbs ; system stack base
	  public sys_sssz ; system stack size
	  public sys_sstp ; system stack top
	  public sys_stat ; original register block
	  public t_mnxtm ; minimum execution time
	  public t_rels  ; release
	  public t_spnd  ; suspend
	  public t_syxtm ; system pseudo time accumulator
	  public t_term  ; reschedule
	  public t_wait  ; wait
	  public t_wqupd ; wait queue update task pointer
	  public t__crtss ; current task ss storage
	  public t__crtsp ; current task sp storage
	  public t__dspap ; dispatch application
	  public t__dspsy ; dispatch system
	  public t__sstk ; establish system stack
	  public t__syntr ; enter system state
	  public t__syxit ; exit system state

MINXTM	  equ 500	 ; minimum execution time
STKLN	  equ 1024	 ; system stack size

	  dseg

tmrdx	  dw 0		 ; dx storage
spdss	  dw 0		 ; ss storage
spdsp	  dw 0		 ; sp storage

t__crtss  dw 0		 ; current task ss storage
t__crtsp  dw 0		 ; current task sp storage

sys_stat  db type sys_parm dup (0) ; original register block
sys_dgrp  dw 0		 ; data segment storage
sys_task  dw 0		 ; current task pointer
sys_tsch  dw 0		 ; task scheduling table pointer
sys_asbs  dw 0		 ; application stack base
sys_ssbs  dw stkbs	 ; system stack base
sys_sssz  dw STKLN	 ; system stack length
sys_sstp  dw STKLN	 ; system stack top
sys_ilck  db 0FFh	 ; system task interlock

t_wqupd   dw 0		 ; wait queue update task pointer

t_syxtm   dw 3 dup (0)	 ; system pseudo time accumulator

t_mnxtm   dw MINXTM	 ; minimum execution time

stkbs	  db STKLN dup (0) ; system stack
	  db type t_task dup (0) ; main task control table

	  endds

	  pseg

comment ~

t__dspap(ss,sp)
selector ss;
unsigned sp;

ss  and  sp are placed in the stack registers.	Then the other	registers  are
restored from the new stack.  Control passes to the restored task.  The return
address  is left at the top of the system stack.  Therefore the restored  task
may use the system stack to return to the caller of t__dspap. ax may contain a
return code in this case.
~

t__dspap  proc near
	  push bp	 ; protect bp
	  mov bp,sp	 ; establish parameter addressability
	  mov ax,[bp].t_np0 ; set application stack
	  mov bx,[bp].t_np1
	  mov sys_sstp,sp ; store current top of system stack
	  cli
	  mov ss,ax
	  mov sp,bx
	  mov bp,sp	 ; enable interrupts
	  or [bp].t_xpf,0200h
	  pop sys_asbs
	  sti
	  sys__rctx	 ; restore context
	  cli		 ; interrupts off
	  mov byte ptr sys_ilck,0 ; exit system state
	  mov byte ptr t_astrm,0 ; initialize application interval
	  pop ds	 ; restore ds
	  iret		 ; execute task
t__dspap  endp

comment ~

t_term()       _F
t_spnd(tp)     tp
t_wait(tp)     tp
unsigned tp;
t_rels()       _E

All of these functions are similar.  The processor registers are stored on
the stack,  which  is  then  adjusted  to  match the pattern for interrupt
returns. Finally the system stack is established.  The	functions  differ  in
the  code returned  to	the caller of function t__dspap.  t__dspap restores
the registers and returns control to the caller of these functions.  The
returned  value  is shown with the appropriate call above.  tp is only used
with t_spnd and t_wait.  It is the number of system ticks to  wait  before
executing  the	task  again.  t_wait functions like t_spnd, except that t_rels
is invoked immediately.  ~

t_term	  proc near
	  call t__trmap  ; protect registers
	  xor ax,ax	 ; return _F
	  ret
t_term	  endp

t_spnd	  proc near
	  mov spdss,ss	 ; store stack pointers
	  mov spdsp,sp
	  call t__trmap  ; protect registers
	  mov es,spdss	 ; return tick count
	  mov si,spdsp
	  mov ax,word ptr es:[si+2]
	  push ds	 ; set es = ds
	  pop es
	  ret		 ; return
t_spnd	  endp

t_wait	  proc near
	  push bp	 ; protect bp
	  mov bp,sp	 ; establish stack addressability
	  mov ax,[bp].t_np0 ; suspend task
	  push ax
	  call t_spnd
	  mov sp,bp	 ; unload stack
	  pop bp	 ; restore bp
t_rels	  proc near
	  call t__trmap  ; protect registers
	  xor ax,ax	 ; return _E
	  dec ax
	  ret
t_rels	  endp
t_wait	  endp

comment ~

t__dspsy()

A call to function t__trmap is made so that after the registers are stored in
the  application stack (and the system stack is made current),	control passes
to  function t__krnl,  the system security kernel.  Control will  return  from
t__dspsy when the calling task is resumed. Nothing is returned.
~

t__dspsy  proc near
	  mov ax,offset pgroup:t__krnl ; branch to system
	  push ax
	  sub sys_sstp,2 ; adjust system stack (for "pop bp" in t__sstk)

comment ~

t__trmap()

The  machine registers are stored on the application stack.  Then the system
stack is made current.	The return address from the call to t__trmap is put on
the system stack before returning to it. Nothing is returned.
~

t__trmap  proc near
	  mov byte ptr sys_ilck,0FFh ; force system state
	  mov tmrdx,dx	 ; save dx
	  pop dx	 ; set return address (from t__trmap)
	  push cs	 ; protect cs
	  pushf 	 ; protect flags
	  push ds	 ; protect ds
	  push ax	 ; protect ax
	  push bx	 ; protect bx
	  push cx	 ; protect cx
	  push tmrdx	 ; protect dx
	  push si	 ; protect si
	  push di	 ; protect di
	  push bp	 ; protect bp
	  push es	 ; protect es
	  push dx	 ; restore return address to stack
	  mov bp,sp	 ; establish stack addressability
	  mov ax,[bp].t_xip ; adjust stack for interrupt return
	  xchg ax,[bp].t_xpf
	  mov [bp].t_xip,ax

comment ~

t__sstk()

The  current application stack pointers are stored.  Then the system stack is
established as the current stack.  The return address from the call is placed
on the system stack before returning into it. Nothing is returned.
~

t__sstk   proc near
	  pop dx	 ; unload return address
	  push sys_asbs  ; protect stack protection reference
	  mov bx,ss	 ; set application stack registers
	  mov cx,sp
	  mov ax,sys_ssbs ; set system stack
	  cli
	  mov sys_asbs,ax
	  push ds
	  pop ss
	  mov sp,sys_sstp
	  sti
	  pop bp	 ; restore bp
	  mov t__crtss,bx ; store current ss
	  mov t__crtsp,cx ; store current bp
	  push dx	 ; return to caller
	  ret
t__sstk   endp
t__trmap  endp
t__dspsy  endp

comment ~

t_sync(flg)
char *flg;

A wait loop will be entered until the required resource is available. This is
indicated  by flg containing 0x00.  0xFF is stored to prevent any other tasks
from acquiring the resource. The resource is released by resetting flg to
0x00.
~

t_sync	  proc near
	  push bp	 ; protect bp
	  mov bp,sp	 ; establish stack addressability
	  mov bx,[bp].t_np0 ; set pointer to resource flag

sync1:	  mov al,0FFh	 ; interlock token
	  ilck al,<byte ptr [bx]>
	  or al,al	 ; test for token acquired
	  jz sync2
	  xor ax,ax	 ; wait for 1 system tick
	  inc ax
	  push ax
	  call t_spnd
	  mov sp,bp
	  jmp sync1	 ; continue

sync2:	  pop bp	 ; restore bp
	  call t_rels	 ; release task
	  ret		 ; return
t_sync	  endp

comment ~

t__syntr(flg)
char *flg;

This function expands the sys_entr macro for use by c functions.
~

t__syntr  proc near
	  push bp	 ; protect bp
	  mov bp,sp	 ; establish stack addressability
	  mov bx,[bp].t_np0 ; set flag address
	  sys_entr <byte ptr [bx]> ; enter system state
	  pop bp	 ; restore bp
	  ret		 ; return
t__syntr  endp


comment ~

t__syxit(flg)
char *flg;

This function expands the sys_exit macro for use by c functions.
~

t__syxit  proc near
	  push bp	 ; protect bp
	  mov bp,sp	 ; establish stack addressability
	  mov bx,[bp].t_np0 ; set flag address
	  sys_exit <byte ptr [bx]> ; exit system state
	  pop bp	 ; restore bp
	  ret		 ; return
t__syxit  endp

	  endps

	  end



