/*
Ŀ
jzputkbd.c								     
Put characters in the keyboard buffer. 				     
									     
Synopsis: jzputkbd("msc test.c/r");                                         
									     
To put extended chars in the buffer, just preface the scan codes with	     
"\377". i.e to put the F1 key in the buffer you would use:                  
   jzputkbd("\377\073");    (\377 is octal for 255, \073 is octal for 59)   
									     
 Note: you must compile this routine with /Ze cuz of the far pointers	     
									     
 (C) JazSoft Software by Jack A. Zucker (301) 794-5950 		     

*/
#include <jaz.h>
#define BUFADDR 0x1E
#if DEBUG
   char far *whead = (char far *) 0x0040001A;	/* head of key buffer */
   char far *wtail = (char far *) 0x0040001C;	/* tail of key buffer */
   int wlen,w;
#endif
jzputkbd(fstr)
unsigned char *fstr;
{

   #if ! DEBUG
   char far *whead = (char far *) 0x0040001A;	/* head of key buffer */
   char far *wtail = (char far *) 0x0040001C;	/* tail of key buffer */
   int wlen,w;
   #endif

   wlen = min(strlen(fstr),16); 	/* buffer holds only 16 chars	*/

   *whead = BUFADDR;			/* point to start of key buffer */

   *wtail = BUFADDR;			/* point to start of key buffer */

   for (w = 1 ; w <= wlen && *fstr ; w ++)
     if (*fstr == 255)
       if (*(fstr+1)) {
	 fstr ++;
	 *(wtail + (w << 1)) = 0;
	 *(wtail + (w << 1)+1) = *fstr++;
	 *wtail += 2;
       }
       else {
	 *(wtail + (w << 1)) = 255;
	 *wtail += 2;
       }
     else {
       *(wtail + (w << 1)) = *fstr++;
       *wtail += 2;
     }
}

