/*************************************************************************
** interpcom-1.1 (command interpreter - tutorial)                        **
** transcmd.c : Commands related to precise Fourier transforms           **
**                                                                       **
** Copyright (C) 1998  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**									 **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details. 			 **
**									 **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free		 **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      Aile 45-55                                                       **
**      2, place Jussieu                                                 **
**      75251 Paris Cedex 05                                             **
**      France								 **
**                                                                       **
 *************************************************************************/


#include "interp.h"
#include "funct.h"




/*--------------------------------------------------------------------------
    Function associated to the command 'def_four'.
--------------------------------------------------------------------------*/
int
def_four_prec(int argc, char *argv[])
{
    int		    i0,
		    iw,
                    i0_b,
                    iw_b,
                    ifft,
		    n;
    char 	  **e,
		  **c,
		   *k[3];
    float	   *x_r;
    double	   *x_rd;
    Tfourier	   *Tr;
    CTfourier      *CTr;
    funct_f	   *a_f;
    funct_d	   *a_d;
    funct_C  	   *a_C;
    funct_dC	   *a_dC;
    Transf	   *Tra;

    iw = sketch_obj(argv[1], &i0);
    if (iw != 0) {
	error_mess(_FUNC_MESS + 0);
        return 1;
    }
    ifft = convert_int(argv[3]);
    if (ifft < 4) {
	error_mess(_FUNC_MESS + 2);
 	return 1;
    }
    n = 1;
    while (n < ifft) {
	n *= 2;
    }
    if (n != ifft) {
	error_mess(23);
        return 1;
    }
    
    k[0] = ch_copy("objdef");
    k[1] = ch_copy_int(_FOUR_TR - 1);
    k[2] = argv[1];
    i0 = obj_create(3, k);
    if (i0 == -1) {
	error_mess(_FUNC_MESS);
        return 1;
    }
    e = (char **) Obj[6][i0].adresse;
    free(k[0]);
    free(k[1]);
    iw_b = sketch_obj_restr(argv[2], &i0_b, _RFUNC_F);
    if (iw_b != _RFUNC_F) {
        iw_b = sketch_obj_restr(argv[2], &i0_b, _RFUNC_D);
	if (iw_b != _RFUNC_D) {
            iw_b = sketch_obj_restr(argv[2], &i0_b, _CFUNC_F);
	    if (iw_b != _CFUNC_F) {
            	iw_b = sketch_obj_restr(argv[2], &i0_b, _CFUNC_D);
    		if (iw_b != _CFUNC_D) {
		    error_mess(_FUNC_MESS + 7);
        	    return 1;
   		}
	    }
	}
    }
    c = (char **) Obj[iw_b - 1][i0_b].adresse;
    Tra = (Transf *) malloc((size_t) sizeof(Transf));

    if (iw_b == _RFUNC_F) {
	a_f = (funct_f *) c[0];
	f_fill(a_f, &x_r);
        if (test_xr_f(x_r, a_f->nb) == 1) {
	    error_mess(_FUNC_MESS + 19);
	    return 1;
	}
	Tr = fTf(&a_f->nb, x_r, a_f->f, ifft, 3);
        Tr->nom_func = ch_copy(a_f->nom);
	Tra->tr = (char *) Tr;
        Tra->type = 0;
        if (a_f->type > 0)
	    XFREE(x_r);
    }
    else {
	if (iw_b == _RFUNC_D) {	
	    a_d = (funct_d *) c[0];
	    d_fill(a_d, &x_rd);
            if (test_xr_d(x_rd, a_d->nb) == 1) {
	        error_mess(_FUNC_MESS + 19);
	        return 1;
	    }
	    Tr = Tf(&a_d->nb, x_rd, a_d->f, ifft, 3);
            Tr->nom_func = ch_copy(a_d->nom);
	    Tra->tr = (char *) Tr;
            Tra->type = 0;
            if (a_d->type > 0)
	        XFREE(x_rd);
	}
	else {
	    if (iw_b == _CFUNC_F) {
	        a_C = (funct_C *) c[0];
	        C_fill(a_C, &x_r);
                if (test_xr_f(x_r, a_C->nb) == 1) {
	            error_mess(_FUNC_MESS + 19);
	            return 1;
	        }
		CTr = CTf(&a_C->nb, x_r, a_C->f, ifft, 3);
                (CTr->Reel)->nom_func = ch_copy(a_C->nom);
	        Tra->tr = (char *) CTr;
                Tra->type = 1;
        	if (a_C->type > 0)
	    	    XFREE(x_r);
	    }
	    else {
	        a_dC = (funct_dC *) c[0];
	        dC_fill(a_dC, &x_rd);
                if (test_xr_d(x_rd, a_dC->nb) == 1) {
	            error_mess(_FUNC_MESS + 19);
	            return 1;
	        }
		CTr = dCTf(&a_dC->nb, x_rd, a_dC->f, ifft, 3);
                (CTr->Reel)->nom_func = ch_copy(a_dC->nom);
	        Tra->tr = (char *) CTr;
                Tra->type = 1;
        	if (a_dC->type > 0)
	    	    XFREE(x_rd);
	    }
	}
    }
    e[0] = (char *) Tra;

    return 0;
}
/*------------------------------------------------------------------------*/




/*--------------------------------------------------------------------------
    Function associated to the command 'trans_four'.
--------------------------------------------------------------------------*/
int
trans_four_prec(int argc, char *argv[])
{
    int		    i,
		    iw,
		    i0,
		    iw0,
		    i00,
		    type;
    Transf	   *Tra;
    Tfourier	   *Tr;
    CTfourier	   *CTr;
    char	  **c,
                  **e;
    float	   *x_r;
    double	   *x_rd;
    funct_C	   *a_C;
    funct_dC	   *a_dC;

    iw = sketch_obj_restr(argv[1], &i0, _FOUR_TR);
    if (iw != _FOUR_TR) {
	error_mess(_FUNC_MESS + 16);
	return 1;
    }
    e = (char **) Obj[iw - 1][i0].adresse;
    iw0 = sketch_obj_restr(argv[2], &i00, _CFUNC_F);
    if (iw0 != _CFUNC_F) {
	iw0 = sketch_obj_restr(argv[2], &i00, _CFUNC_D);
        if (iw0 != _CFUNC_D) {
	    error_mess(_FUNC_MESS + 7);
	    return 1;
        }
    }
    c = (char **) Obj[iw0 - 1][i00].adresse;
    Tra = (Transf *) e[0];
    type = Tra->type;

    if (iw0 == _CFUNC_F) {
        a_C = (funct_C *) c[0];
	C_fill(a_C, &x_r);
        if (type == 0) {
	    Tr = (Tfourier *) Tra->tr;
	    for (i = 1; i <= a_C->nb; i++)
		a_C->f[i] = fTrans(Tr, x_r[i]);
        }
	else {
	    CTr = (CTfourier *) Tra->tr;
	    for (i = 1; i <= a_C->nb; i++)
		a_C->f[i] = CTrans(CTr, x_r[i]);
        }
        if (a_C->type > 0)
	    XFREE(x_r);
    }
    else {
        a_dC = (funct_dC *) c[0];
	dC_fill(a_dC, &x_rd);
        if (type == 0) {
	    Tr = (Tfourier *) Tra->tr;
	    for (i = 1; i <= a_dC->nb; i++)
		a_dC->f[i] = Trans(Tr, x_rd[i]);
        }
	else {
	    CTr = (CTfourier *) Tra->tr;
	    for (i = 1; i <= a_dC->nb; i++)
		a_dC->f[i] = dCTrans(CTr, x_rd[i]);
        }
        if (a_dC->type > 0)
	    XFREE(x_rd);
    }
    return 0;
}
/*------------------------------------------------------------------------*/




/*--------------------------------------------------------------------------
    Function that is called when a command of destruction of a Fourier 
    object is given.
--------------------------------------------------------------------------*/
void
detruit_four_prec(int iw, int i0)
{
    Transf	   *Tra;
    char	  **e;

    e = (char **) Obj[iw - 1][i0].adresse;
    Tra = (Transf *) e[0];
    if (Tra->type == 0) {
	Detruit((Tfourier *) Tra->tr);
    }
    else {
	CDetruit((CTfourier *) Tra->tr);
    }
    free(Tra);
}
/*------------------------------------------------------------------------*/




/*--------------------------------------------------------------------------
--------------------------------------------------------------------------*/
int
test_xr_f(float *x_r, int n)
{
    int		    i;

    for (i = 1; i < n; i++)
	if (x_r[i + 1] - x_r[i] <= 0)
	    return 1;
    return 0;
}
/*------------------------------------------------------------------------*/




/*--------------------------------------------------------------------------
--------------------------------------------------------------------------*/
int
test_xr_d(double *x_r, int n)
{
    int		    i;

    for (i = 1; i < n; i++)
	if (x_r[i + 1] - x_r[i] <= 0)
	    return 1;
    return 0;
}
/*------------------------------------------------------------------------*/
