/*************************************************************************
** interpcom-1.1  (command interpreter)                                  **
** com_sys.c : Execution of commands, and system commands                **
**                                                                       **
** Copyright (C) 1998  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**									 **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details. 			 **
**									 **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free		 **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      Aile 45-55                                                       **
**      2, place Jussieu                                                 **
**      75251 Paris Cedex 05                                             **
**      France								 **
**                                                                       **
 *************************************************************************/

#define _DEF_PFI_INTERP
#include "interp.h"

char           *esp_decalage = "                         ";



/*--------------------------------------------------------------------
    Fonction retournant -1 si 'nom_cmd' n'est pas un nom de 
    commande stockee en memoire, sinon le numero de la commande
--------------------------------------------------------------------*/ 
int
lookup_b(char *nom_cmd) 
{
    int 	    i;

    for (i = 0; i < nb_com; i++) {
	if (comp(nom_cmd, nom_com[i]) == 1) {
            if (mode_com_int[i][mode_fonct_] == 1)
	        return i;
            else
		err_mess(25);
        }
    }

    return -1;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Fonction interpretant les lignes du programme numero i_com, et les
    executant. Cette fonction est appelee par la fonction 'shell_c' et 
    l'appelle aussi (cette fonction interprete les lignes de commandes 
    et les execute).
--------------------------------------------------------------------*/
void
execute(int i_com, int argc, char *argv[])
{
    int 	    i,
		    ii,
		    i0,
		    ik,
		    iw,
		    j,
		    k,
		    l,
		    nb,
                    nb_c,
		    argc_com,
                    slen;
    char	   *u,
		   *argv_com[20],
		    h[300],
		    ch,
		    c;
    float	    x,
		    xb;

    i_com_cur = i_com;
    if (argc < nb_par[i_com] + 1) {
	err_mess(0);
	return;
    }
    nb = 0;
    xb = 0.;
    argc_com = 0;
    is_com = 1;
    for (i = 0; i < 20; i++)
	argv_com[i] = NULL;
    i = 0;
    i_ligne_cur = 0;
    i_lec_cur = 0;
    nb_c = nb_lignes[i_com];

    while (i < nb_c) {
        if (ligne_com[i_com][i][0] == '[') {
	    i_speed = 1;
            goto suite;
        }
        if (ligne_com[i_com][i][0] == ']') {
	    i_speed = 0;
            goto suite;
        }
        extrait_argv_com(i_com, &argc_com, i, argv_com); 
       
        for (ik = 0; ik < argc_com; ik++) {
            slen = strlen(argv_com[ik]);
            u = argv_com[ik];
            k = -1;
            j = -1;
            iw = 0;

            while (j < slen - 1) {
	        if (u[++j] != '#' && u[j] != '!' && u[j] != '%' && 
		    u[j] != '$') {
		    hcom[++k] = u[j];
	        }
	        else {
                    if (u[j] == '#') {
                        iw = 1;
		        ii = u[j + 1] - 48;
                        j++;
                        if (argv[ii] == NULL) {
                            free(argv_com[ik]);
                            argv_com[ik] = NULL;
                            argc_com = ik;
			    goto xxx;
                        }
                        if (ii > 0 && ii < 20 && ii < argc) {
		            for (i0 = 0; i0 < (int) strlen(argv[ii]); i0++) {
			        hcom[++k] = argv[ii][i0];
		            }	
                        }
		    }
		    else {
                        if (u[j] == '$') {
 			    c = u[j++];
                            iw = 1;
                            if (j >= slen - 2 || u[j] != '(')
			        break;
                            j++;
                            l = -1;
                            memset(h, 0, 300);

                            while (j < slen && u[j] != ')') {
                                h[++l] = u[j++];
                            }

                            if (l < 0) 
			        nb = -1;
                            else 
			        nb = convert_int(h);
                            if (nb >=0 && nb <= __max_quest)
                                for (i0 = 0; i0 < (int) strlen(ques[nb]); i0++) 
			            hcom[++k] = ques[nb][i0];
                       }
			else {
			    c = u[j++];
                            iw = 1;
                            if (j >= slen - 2 || u[j] != '(')
			        break;
                            j++;
                            l = -1;
                            memset(h, 0, 300);

                            while (j < slen && u[j] != ')') {
                                h[++l] = u[j++];
                            }

                            if (l < 0) {
			        if (c == '!')
			            nb = 0;
			        else
				    xb = 0.;
                            }
                            else {
                                if (c == '!')
			            nb = convert_int(h);
                                else
				    xb = convert_float(h);
                            }
                            memset(h, 0, 300);
                            if (c == '!')
                                sprintf(h, "%d", nb);
                            else
                                sprintf(h, "%f", xb);
                            for (i0 = 0; i0 < (int) strlen(h); i0++) 
			        hcom[++k] = h[i0];
		        }
		    }
	        }
	    }

	    if (iw == 1) {
	        if (argv_com[ik] != NULL)
		    free(argv_com[ik]);
                argv_com[ik] = (char *) malloc((size_t)(k + 2) *
		    sizeof(char));
                memcpy(argv_com[ik], hcom, k + 1);
                argv_com[ik][k + 1] = 0;
	    }
        }

        ch = argv_com[0][0];
        if (ch == _EVAL) {
	    memset(h, 0, 300);
            for (l = 1; l < argc_com; l++)
		strcat(h, argv_com[l]);
            convert_float(h);
            goto suite;
        }
        if (ch == _GOTO) {
            i = num_label[i_com][atoi(argv_com[1])] - 1;
 	    goto suite;
        }
        if (ch == _IFGT) {
            x = convert_float(argv_com[1]);
            if (x > 0.0) {
		i = num_label[i_com][atoi(argv_com[2])] - 1;
                goto suite;
	    }
            if (argc_com > 3)
		i = num_label[i_com][atoi(argv_com[3])] - 1;
	    goto suite;
        }
        if (ch == _IFLT) {
            x = convert_float(argv_com[1]);
            if (x < 0.0) {
		i = num_label[i_com][atoi(argv_com[2])] - 1;
                goto suite;
	    }
            if (argc_com > 3)
		i = num_label[i_com][atoi(argv_com[3])] - 1;
	    goto suite;
        }
        if (ch == _IFEQ) {
            x = convert_float(argv_com[1]);
            if (x == 0.0) {
		i = num_label[i_com][atoi(argv_com[2])] - 1;
                goto suite;
	    }
            if (argc_com > 3)
		i = num_label[i_com][atoi(argv_com[3])] - 1;
	    goto suite;
        }

xxx:    if (sil_com[i_com] == 0)
	    prlevel++;
        if (prlevel <= 0) {
   	    print("%s", prompt_mode[__nmode_fonc - 1]); 

            for (ii = 0; ii < argc_com; ii++) {
	        print("%s ", argv_com[ii]);
	    }

            print("\n");
        }
        i_lec_cur = 0;
        shell_c(argc_com, argv_com);
        i += i_lec_cur;
        i_lec_cur = 0;
        is_com = 1;
        if (sil_com[i_com] == 0)
   	    prlevel--;
suite:
        i++;
        i_ligne_cur = i;
    }

    for (i = 0; i < 20; i++)
	if (argv_com[i] != NULL)
	    free(argv_com[i]);
    is_com = 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Chargement en memoire des programmes situees dans le fichier 'g'.
--------------------------------------------------------------------*/
void 
charge_com(char *g, char xg[], int nb)
{
    int 	    i,
		    j,
                    l,
                    slen,
		    nb_par_b,
		    sil_com_b;
    char	    h_ligne[100],
		    nom_com_b[100],
		    k[100],
		    direct[256],
		    inverse[256],
                   *xg_c;
    FILE	   *s;

    if (g != NULL) 
        s = fopen(g, "r");
    else {
        __perms(direct, inverse);
        xg_c = __Xdecode(xg, nb, inverse);
	s = fmemopen((void *) xg_c, nb, "r");
        free(xg_c);
    }
    if (s == NULL) {
        if (ind_com == 0)
	    exit_interp(NULL);
        else {
            err_mess(23);
	    return;
        }
    }
    memset(h_ligne, 0, 100);

    while (fgets(h_ligne, 99, s) != NULL) {

/*----------------------------------------------------
    Cas d'un programme (debut)
----------------------------------------------------*/
        if (h_ligne[0] == ':') {
            slen = strlen(h_ligne);
            if (slen <= 2) {
                if (ind_com == 0)
		    exit_interp(NULL);
                else {
		    fclose(s);
                    err_mess(22);
                    return;
                }
            }
/*--- Nom de la commande ----------------*/
            memcpy(nom_com_b, h_ligne + 1, slen - 2);
            for (i = slen - 2; i < 100; i++)
		nom_com_b[i] = 0;
            if (exist_com(nom_com_b) == 1) {
		err_mess(26);
                fclose(s);
                return;
            }
            memset(h_ligne, 0, 100);
            j = 0;     

       
/*--- Nombre de parametres -------------*/
            while (j == 0) {
                if (fgets(h_ligne, 99, s) == NULL) {
                    if (ind_com == 0)
		        exit_interp(NULL);
                    else {
		        fclose(s);
                        err_mess(22);
                        return;
                    }
                }
                if (h_ligne[0] != ';')
		    j = 1;
            }

   	    nettoie(h_ligne);
            nb_par_b = convert_int(h_ligne);
            if (nb_par_b <= 0 || nb_par_b > 10) {
                if (ind_com == 0)
		    exit_interp(NULL);
                else {
		    fclose(s);
                    err_mess(22);
                    return;
                }
             }
/*--------------------------------------*/   


/*--- Indice de silence ----------------*/
            j = 0;            

            while (j == 0) {
                if (fgets(h_ligne, 99, s) == NULL) {
                    if (ind_com == 0)
		        exit_interp(NULL);
                    else {
		        fclose(s);
                        err_mess(22);
                        return;
                    }
                }

                if (h_ligne[0] != ';') /* ligne de commentaire */
		    j = 1;
            }
            
            nettoie(h_ligne);
            sil_com_b = convert_int(h_ligne);
/*--------------------------------------*/   

       
/*--- Modes de fonctionnement ----------*/   
            j = 0;            

            while (j == 0) {
                if (fgets(h_ligne, 99, s) == NULL) {
                    if (ind_com == 0)
		        exit_interp(NULL);
                    else {
		        fclose(s);
                        err_mess(22);
                        return;
                    }
                }
                if (h_ligne[0] != ';') /* ligne de commentaire */
		    j = 1;
            }
            
            nettoie(h_ligne);
	    slen = strlen(h_ligne);
            i = 0;
            j = -1;
            memset(k, 0, 100);
            nb_com++;

            while (i < slen) {
	        if (h_ligne[i] != ' ') {
	   	    j++;
                    k[j] = h_ligne[i];
                    i++;
                }
                if (h_ligne[i] == ' ' || i == slen) {
                    if ((int) strlen(k) > 0) {
	                j = convert_int(k);
                        if (j < 0)
		            for (l = 0; l < __nmode_fonc; l++)
		                mode_com_int[nb_com - 1][l] = 1;
                        else
		            if (j < __nmode_fonc)
			        mode_com_int[nb_com - 1][j] = 1;
	                memset(k, 0, 100);
                        j = -1;
		    }
                    i++;
                }
            }
/*--------------------------------------*/   


/*--- Initialisations ------------------*/   
            nom_com[nb_com - 1] = (char *) malloc((size_t) 
		(strlen(nom_com_b) + 1) * sizeof(char));
            sprintf(nom_com[nb_com - 1], "%s", nom_com_b);
	    nom_com[nb_com - 1][strlen(nom_com_b)] = 0;
            nb_par[nb_com - 1] = nb_par_b - 1;
            sil_com[nb_com - 1] = sil_com_b;
            nb_lignes[nb_com - 1] = 0;
            nb_label[nb_com - 1] = 0;
/*--------------------------------------*/   
	}
/*--------------------------------------------------*/

        else {



/*----------------------------------------------------
    Cas d'une commande systeme
----------------------------------------------------*/
            if (h_ligne[0] == '!') {
                if (ind_com == 1) {
                    fclose(s);
		    return;
                }
                else  
   		    interp_com(s, h_ligne);
            }
/*--------------------------------------------------*/
            else {



/*----------------------------------------------------
    Cas d'un programme (lignes)
----------------------------------------------------*/
	        if (h_ligne[0] != ';' && h_ligne[0] != '\n' &&
                    h_ligne[0] != ' ' && nb_com > 0) {
		    if (nb_lignes[nb_com - 1] < __nblignes - 1) {
                        slen = strlen(h_ligne);
 		        ligne_com[nb_com - 1][nb_lignes[nb_com - 1]] =
		            (char *) malloc((size_t) slen * sizeof(char));
                        memcpy(ligne_com[nb_com - 1][nb_lignes[nb_com - 1]],
			    h_ligne, slen - 1);
		        ligne_com[nb_com - 1][nb_lignes[nb_com - 1]]
			    [slen - 1] = 0;
                        nb_lignes[nb_com - 1]++;
                    }
		    else 
		        err_mess(27);
		}
	    }
/*--------------------------------------------------*/
	}
	memset(h_ligne, 0, 100);
    }

    fclose(s);
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Fonction executant la fonction associee a une commande
    de base de l'interpreteur de commandes
---------------------------------------------------------------------*/
void
interp_com(FILE *s, char *h_ligne)
{
    int		    i;
    char	   *name_c;

    i = 0;
    name_c = h_ligne + 1;
    name_c[strlen(name_c) - 1] = 0;
    
    while (namesb[i][0] != ' ') {
	if (comp(namesb[i], name_c) == 1) {
	    (*(procb[i])) (s, name_c);
            return;
	}
        i++;
    }
}
/*-------------------------------------------------------------------*/



/*---------------------------------------------------------------------
    Commande systeme de lecture du 'prompt' d'un mode de fonctionnement.
    (commande 'mode')
---------------------------------------------------------------------*/
int		
mode_cmd(FILE *s, char *name_c)
{
    int		    slen;
    char	    h_ligne[100];

    memset(h_ligne, 0, 100);
    if (nb_mode_fonc >= __nmode_fonc - 2) 
	exit_interp("mode");
    nb_mode_fonc++;
    if (fgets(h_ligne, 99, s) == NULL) 
	exit_interp("mode");    
    slen = strlen(h_ligne) - 1;
    if (slen == 1)
	exit_interp("mode");
    h_ligne[slen] = 0;
    prompt_mode[nb_mode_fonc] = (char *) malloc((size_t) (slen + 1)
  	* sizeof(char));
    memcpy(prompt_mode[nb_mode_fonc], h_ligne, slen);
    prompt_mode[nb_mode_fonc][slen] = 0;
    ind_x_mode = 1;

    return 0;
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Fonction lisant des chaines de caracteres. Appelee par certaines
    commandes de base de l'interpreteur.
---------------------------------------------------------------------*/
int		
gr_cmd(FILE *s, char *name_c, char **gr, int *i_gr, int i_grmax)
{
    int		    slen;
    char	    h_ligne[100];
   
    i_gr[0] = -1;
    memset(h_ligne, 0, 100);     

    while (fgets(h_ligne, 99, s) != NULL && i_gr[0] < i_grmax) {
	if (h_ligne[0] == '.')
	    return 0;
        if (h_ligne[0] != ';') {
            i_gr[0]++;
            slen = strlen(h_ligne) - 1;
            if (h_ligne[slen - 1] == 'n' && h_ligne[slen - 2] == 92) {
                h_ligne[slen - 2] = '\n';
                slen--;
            }
            gr[i_gr[0]] = (char *) malloc((size_t) (slen + 2) * 
	        sizeof(char));
            memcpy(gr[i_gr[0]], h_ligne, slen);
            gr[i_gr[0]][slen] = 0;
	}
    }    

    return 0;
}
/*-------------------------------------------------------------------*/



/*---------------------------------------------------------------------
    Commande systeme de lecture de ce qui est affiche au debut de
    l'execution du programme (commande 'greet')
---------------------------------------------------------------------*/
int		
greet_cmd(FILE *s, char *name_c)
{
    return gr_cmd(s, name_c, greet, &i_greet, __greet_max);
}
/*-------------------------------------------------------------------*/



/*---------------------------------------------------------------------
    Commande systeme de lecture des messages pouvant etre affiches
    par le programme (commande 'message')
---------------------------------------------------------------------*/
int
mess_cmd(FILE *s, char *name_c)
{
    return gr_cmd(s, name_c, mess, &i_message, __mess_max);
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Commande systeme de lecture des noms des commandes du programme,
    de leur nombre minimal de parametres et de leur mode de
    fonctionnement (commande 'func')
---------------------------------------------------------------------*/
int		
func_cmd(FILE *s, char *name_c)
{
    int		    slen,
		    i,
		    j,
		    l;
    char	    h_ligne[100],
		    k[100];
   
    nb_commandes = -1;   
    memset(h_ligne, 0, 100);  

    while (fgets(h_ligne, 99, s) != NULL && nb_commandes < 
	__com_max - 1) {
	if (h_ligne[0] == '.') {
            ch_prem();
            if (nb_commandes >= 0)
		ind_x_func = 1;
	    return 1;
        }
        nb_commandes++;
        slen = strlen(h_ligne) - 1;
        names[nb_commandes] = (char *) malloc((size_t) (slen + 1) *
	    sizeof(char));
        memcpy(names[nb_commandes], h_ligne, slen);
        len_n[nb_commandes] = slen;
        names[nb_commandes][slen] = 0;
        memset(h_ligne, 0, 100);
        if (fgets(h_ligne, 99, s) == NULL)
	    exit_interp("func");
        nettoie(h_ligne);
        par_com[nb_commandes] = convert_int(h_ligne);
        if (par_com[nb_commandes] < 1 || par_com[nb_commandes] > __nbargmax)
	    exit_interp("func");
        memset(h_ligne, 0, 100);
        if (fgets(h_ligne, 99, s) == NULL)
	    exit_interp("func");
        nettoie(h_ligne);
        slen = strlen(h_ligne);
        i = 0;
        j = -1;
        memset(k, 0, 100);

        while (i < slen) {
	    if (h_ligne[i] != ' ') {
		j++;
                k[j] = h_ligne[i];
                i++;
            }
            if (h_ligne[i] == ' ' || i == slen) {
                if ((int) strlen(k) > 0) {
	            j = convert_int(k);
                    if (j < 0)
		        for (l = 0; l < __nmode_fonc; l++)
		            mode_com[nb_commandes][l] = 1;
                    else
		        if (j < __nmode_fonc)
			    mode_com[nb_commandes][j] = 1;
	            memset(k, 0, 100);
                    j = -1;
		}
                i++;
            }
        }
    }

    ch_prem();
    if (nb_commandes >= 0)
	ind_x_func = 1;
    return 0;
}
/*-------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Ordonne alphabetiquement les noms de commandes
    et cherche quelles sont les commandes dont la premiere
    lettre est un caractere donne
---------------------------------------------------------------------*/
void
ch_prem(void) 
{
    int		    i,
		    j,
		    k;

    k = 0;
    for (i = 0; i < nb_commandes - 1; i++) 
	if (est_avant(i + 1, i) == 1)
	    k = 1;

    if (k == 1) {
        for (i = 0; i < nb_commandes; i++) 
	    for (j = i + 1; j < nb_commandes; j++)
	        if (est_avant(j, i) == 1)
  	            echange_nom(i, j);
    }

    for (i = 0; i < 127; i++) {
        deb_nom[i] = nb_commandes + 1;

        for (j = 0; j <= nb_commandes; j++) {
	    if (names[j][0] == (char) i) {
		deb_nom[i] = j;
                break;
            }
        }

        fin_nom[i] = -1;
        if (deb_nom[i] <= nb_commandes) {
	    for (k = j; k <= nb_commandes; k++)
		if (names[k][0] == (char) i)
		    fin_nom[i] = k;
        }
    }
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Retourne 1 si le nom de commande i0 est avant le nom de
    commande i1 (pour l'ordre alphabetique).
---------------------------------------------------------------------*/
int
est_avant(int i0, int i1)
{
    int 	    i;

    i = 0;

    while (names[i0][i] != 0) {
	if (names[i1][i] == 0)
	    return 0;
	if (names[i0][i] < names[i1][i])
	    return 1;
        if (names[i0][i] > names[i1][i])
	    return 0;
        i++;
    }

    return 1;
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Interchange les commandes i0 et i1
---------------------------------------------------------------------*/
void
echange_nom(int i0, int i1)
{
    char 	    h[100],
		    k[100];
    int		    i,
		    j;
    pfi		    f;
    
    memset(h, 0, 100);
    memset(k, 0, 100);
    strcpy(h, names[i0]);
    strcpy(k, names[i1]);
    free(names[i0]);
    free(names[i1]);
    names[i0] = ch_copy(k);
    names[i1] = ch_copy(h);
    i = par_com[i0];
    par_com[i0] = par_com[i1];
    par_com[i1] = i;

    for (i = 0; i < __nmode_fonc; i++) {
	 j = mode_com[i0][i];
         mode_com[i0][i] = mode_com[i1][i];
         mode_com[i1][i] = j;
    }

    f = proc[i0];
    proc[i0] = proc[i1];
    proc[i1] = f;
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Fonction retournant 1 si le nombre de parametres d'une 
    commande est superieur ou egal au nombre requis, 0 sinon.
---------------------------------------------------------------------*/
int
test_param(int nb_arg, int i_com)
{ 
    if (nb_arg < par_com[i_com]) {
        err_mess(0);
	return 0;
    }
    return 1;
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Commande systeme de lecture des noms des parametres du programme,
    (commande 'param')
---------------------------------------------------------------------*/
int		
param_cmd(FILE *s, char *name_c)
{
    int		    i,
		    j,
		    nb,
		    slen;
    char	    h_ligne[100];
   
    nb = 0;
    memset(h_ligne, 0, 100);

    while (fgets(h_ligne, 99, s) != NULL && nb < 16) {
        if (h_ligne[0] == '.') {
	    if (nb == 15)
		ind_x_param = 1;
	    return 0;
        }
        if (h_ligne[0] != ';') {
 	    nb++;
            slen = strlen(h_ligne) - 1;
            h_ligne[slen] = 0;

            if (nb == 1) {   /* Nombre maximal de programmes */
		__nbcom = convert_int(h_ligne);
                if (__nbcom < 1) 
		    exit_interp("param");
		nb_par = (int *) malloc((size_t) __nbcom * sizeof(int));
		sil_com = (int *) malloc((size_t) __nbcom * sizeof(int));
		nb_lignes = (int *) malloc((size_t) __nbcom * sizeof(int));
                nom_com = (char **) malloc((size_t) __nbcom * 
		    sizeof(char *));
                ligne_com = (char ***) malloc((size_t) __nbcom * 
		    sizeof(char **));
                mode_com_int = (int **) malloc((size_t) __nbcom * 
		    sizeof(int *));
		nb_label = (int *) malloc((size_t) __nbcom * sizeof(int));
		tr_label = (int *) malloc((size_t) __nbcom * sizeof(int));
		    for (i = 0; i < __nbcom; i++)
			tr_label[i] = 0;
                num_label = (int **) malloc((size_t) __nbcom * 
		    sizeof(int *));
            }

            if (nb == 2) {   /* Nombre maximal de lignes d'un programme */
		__nblignes = convert_int(h_ligne);
                if (__nblignes < 1) 
		    exit_interp("param");

                for (i = 0; i < __nbcom; i++) 
	            ligne_com[i] = (char **) malloc((size_t) __nblignes *
	 		sizeof(char *));
            }

            if (nb == 3) {   /* Nombre maximal de commandes */
		__com_max = convert_int(h_ligne);
                if (__com_max < 60) 
		    exit_interp("param");
                names = (char **) malloc((size_t)__com_max * sizeof(char *));
		mode_com = (int **) malloc((size_t) __com_max * 
		    sizeof(int *));
		par_com = (int *) malloc((size_t) __com_max * sizeof(int));
                len_n = (int *) malloc((size_t) __com_max * sizeof(int));
                deb_nom = (int *) malloc((size_t) __com_max * sizeof(int));
                fin_nom = (int *) malloc((size_t) __com_max * sizeof(int));
            }

            if (nb == 4) {   /* Nombre maximal de lignes du message 
				de debut                             */
		__greet_max = convert_int(h_ligne);
                if (__greet_max < 1) 
		    exit_interp("param");
		greet = (char **) malloc((size_t)__greet_max * 
		    sizeof(char *));
	    }

            if (nb == 5) {   /* Nombre maximal de messages           */
		__mess_max = convert_int(h_ligne);
                if (__mess_max < 1) 
		    exit_interp("param");
		mess = (char **) malloc((size_t)__mess_max * 
		    sizeof(char *));
	    }

            if (nb == 6) {   /* Nombre maximal de fichiers ouverts   */
		__nss = convert_int(h_ligne);
                if (__nss < 1) 
		    exit_interp("param");
                sS = (FILE **) malloc((size_t) __nss * sizeof(FILE *));
                sS_cmpt = (int *) malloc((size_t) __nss * sizeof(int));
                sS_i_o = (int *) malloc((size_t) __nss * sizeof(int));

                for (i = 0; i < __nss; i++) {	
                    sS[i] = NULL;
                    sS_cmpt[i] = 0;
                }

                sS_nom = (char **) malloc((size_t) __nss * sizeof(char *));
	    }

            if (nb == 7) {   /* Nombre maximal de modes de 
				fonctionnement                       */
		__nmode_fonc = convert_int(h_ligne);
                if (__nmode_fonc < 1) 
		    exit_interp("param");

                for (i = 0; i < __com_max; i++) {
		    mode_com[i] = (int *) malloc((size_t) __nmode_fonc *
   			sizeof(int));
		    for (j = 0; j < __nmode_fonc; j++)
			mode_com[i][j] = 0;
                }

                for (i = 0; i < __nbcom; i++) {
		    mode_com_int[i] = (int *) malloc((size_t) __nmode_fonc *
   			sizeof(int));
		    for (j = 0; j < __nmode_fonc; j++)
			mode_com_int[i][j] = 0;
                }

                prompt_mode = (char **) malloc((size_t) __nmode_fonc *
		    sizeof(char *));
                prompt_mode[__nmode_fonc - 1] = 
	            (char *) malloc((size_t) 25 * sizeof(char));
                memset(prompt_mode[__nmode_fonc - 1], 0, 25);
                sprintf(prompt_mode[__nmode_fonc - 1], 
		    " ------------------> ");
            }

            if (nb == 8) {   /* Nombre maximal de voix               */
                __maxvoice = convert_int(h_ligne);
                if (__maxvoice < 2) 
		    exit_interp("param");
		inp = (FILE **) malloc((size_t) __maxvoice * sizeof(FILE *));
                for (i = 0; i < __maxvoice; i++)
		    inp[i] = NULL;
                argv_x = 
		    (argv_t *) malloc((size_t) __maxvoice * sizeof(argv_t));
                argc_x = (int *) malloc((size_t) __maxvoice * sizeof(int));
                for (i = 0; i < __maxvoice; i++)
		    argc_x[i] = 0;
	    }

            if (nb == 9) {   /* Nombre maximal de conditions         */
		__nbcond = convert_int(h_ligne);
                if (__nbcond < 1) 
		    exit_interp("param");
                s_cond = (int *) malloc((size_t) __nbcond * sizeof(int));
                v_cond = (v_c *) malloc((size_t) __nbcond * sizeof(v_c));
	    }

            if (nb == 10) {  /* Nombre maximal de types d'objet     */
		__nbtypmax = convert_int(h_ligne);
                if (__nbtypmax < 1) 
		    exit_interp("param");
	    }

	    if (nb == 11) {  /* Nombre maximal d'arguments des fonctions */
		__nbargmax = convert_int(h_ligne);
                if (__nbargmax < 5) 
		    exit_interp("param");
	    }
            if (nb == 12) {  /* Nombre maximal de types de structures   */
		__nbstrucmax = convert_int(h_ligne);
                 if (__nbstrucmax < 1) 
		    exit_interp("param");
           }
            if (nb == 13) {  /* Nombre maximal de labels dans un 
			        programme  */
		__nblabelmax = convert_int(h_ligne);
                if (__nblabelmax < 5) 
		    exit_interp("param");
	    }
            if (nb == 14) {  /* Nombre maximal de chaines de caracteres   
				entrees par un fichier de questions     */
		__max_quest = convert_int(h_ligne);
                if (__max_quest < 1) 
		    exit_interp("param");
                ques = (char **) malloc((size_t) __max_quest * sizeof(char *));
                for (i = 0; i < __max_quest; i++)
		    ques[i] = (char *) malloc((size_t) 300 * sizeof(char));
	    }
	    if (nb == 15) {  /* Nombre maximal de commandes precedentes */
		__n_com_prec = convert_int(h_ligne);
                if (__n_com_prec < 1) 
		    exit_interp("param");
		com_prec = (char **) malloc((size_t) __n_com_prec * 
		    sizeof(char *));
		for (i = 0; i < __n_com_prec; i++)
		    com_prec[i] = NULL;
	    }
       }
	memset(h_ligne, 0, 100);
    }

    if (nb == 15)
	ind_x_param = 1;
    else 
	exit_interp("param");
    return 0;
}
/*-------------------------------------------------------------------*/



/*---------------------------------------------------------------------
    Commande systeme de creation et lecture de variables cachees
    (commande var)
---------------------------------------------------------------------*/
int
var_cmd(FILE *s, char *name_c)
{
    int		    n;
    char	    h_ligne[100],
		    h[150],
                    k[200];
   
    memset(h_ligne, 0, 100);

    while (fgets(h_ligne, 99, s) != NULL) {
        if (h_ligne[0] == '.')
	    return 0;
        if (h_ligne[0] != ';') {
            memset(h, 0, 150);
	    nettoie(h_ligne);
            strcat(h, h_ligne);
	    memset(h_ligne, 0, 100);
            if (fgets(h_ligne, 99, s) == NULL)
	        exit_interp("var");
	    nettoie(h_ligne);
            n = convert_int(h_ligne);
	    memset(k, 0, 200);
            sprintf(k, "%s=%d", h, n);
            n = S_convert_int(k);
	    memset(h_ligne, 0, 100);
	}
    }

    return 0;
}
/*-------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Fonction appelee lors de la terminaison de
    l'execution de l'interpreteur de commandes
---------------------------------------------------------------------*/
void
exit_sys(void)
{
    int 	    i;

    for (i = 0; i < __nss; i++)
        if (sS[i] != NULL)
	    fclose(sS[i]);
    exit(0);
}
/*-------------------------------------------------------------------*/




/*----------------------------------------------------------------------
    Commande systeme permettant de lire le nom des repertoires
    de donnees, de resultats et de commandes (commande 'rep')
----------------------------------------------------------------------*/
int
rep_cmd(FILE *s, char *name_c)
{
    int		    n;
    char	    h_ligne[100];
   
    memset(h_ligne, 0, 100);
    n = 0;

    while (fgets(h_ligne, 99, s) != NULL) {
        if (h_ligne[0] == '.' && n == 4) {
	    ind_x_rep = 1;
	    return 0;
	}
        if (h_ligne[0] != ';') {
	    nettoie(h_ligne);
            if (n == 0) {
                memset(command_rep, 0, 80);
                strcpy(command_rep, h_ligne);
	    }
            if (n == 1) {
                memset(result_rep, 0, 80);
	        strcpy(result_rep, h_ligne);
            }
            if (n == 2) {
		memset(data_rep, 0, 80);
		strcpy(data_rep, h_ligne);
	    }
            if (n == 3) {
		memset(data_rep2, 0, 80);
		strcpy(data_rep2, h_ligne);
	    }
            memset(h_ligne, 0, 100);
            n++;
	}
    }

    if (n == 4)
	ind_x_rep = 1;
    else
	exit_interp("rep");
    return 1;
}
/*-----------------------------------------------------------------*/




/*----------------------------------------------------------------------
    Commande systeme permettant de lire le nom des repertoires
    de donnees, de resultats et de commandes (commande 'rep')
----------------------------------------------------------------------*/
int
init_interp_cmd(FILE *s, char *name_c)
{
    int		    n,
                    i,
                    j,
                    ind,
		    argn;
    char	    h_ligne[100],
		    argtemp[100];
   
    n = 0;
    argn = -1;

    while (fgets(h_ligne, 99, s) != NULL) {
        if (n == 2) {
            i_init_interp = 1;
            argc_init_interp = argn + 1;
	    return 0;
 	}
        nettoie(h_ligne);
    	if (n == 0) {
	    n = 1;
            sil_init_interp = convert_int(h_ligne);
	}
        else {
	    n = 2;
	    argn = -1;
    	    i = 0;
    	    ind = 0;
	    j = 0;

            while (h_ligne[i] != 0) {
	        if (h_ligne[i] != ' ') {
                    ind = 1;
	            argn++;
                    j = 0;
                    argtemp[j] = h_ligne[i++];

                    while (h_ligne[i] != ' ' && h_ligne[i] != 0) {
                        argtemp[++j] = h_ligne[i++];
	            }
                }
	        i++;
                if (ind == 1) {
                    argv_init_interp[argn] = malloc((size_t) (j + 2) * 
		        sizeof(char));
                    memcpy(argv_init_interp[argn], argtemp, j + 1);
                    argv_init_interp[argn][j + 1] = 0;
                    memset(argtemp, 0, 100);
                }
                ind = 0;
            }
        }
    }

    exit_interp("init");
    return 1;
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Terminaison anormale du programme
-------------------------------------------------------------------*/
void
exit_interp(char *w)
{
#ifdef _ENG_LANG
    if (w != NULL)
        printf("Error in the section %s of the initialization file\n", w);
    else
	printf("Error in the initialization file\n");
#else
    if (w != NULL)
        printf("Erreur dans la section %s du fichier d'initialisation\n",w);
    else
	printf("Erreur dans le fichier d'initialisation\n");
#endif
    exit(0);
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Affichage d'un message d'erreur
-------------------------------------------------------------------*/
void
err_mess(int i)
{
    printf(" %s ; %s\n", esp_decalage, mess_interp[i]);
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Traitement des 'goto', 'if', 'do' des programmes
-------------------------------------------------------------------*/
void
traite_label(void)
{
    int		    i,
                    argc_com,
		    j,
		    k,
		    l,
		    n,
		   *nb;
    char	  **nom_label,
                   *argv_com[20],
                   *v,
		    h[200],
                    h1[200],
		    h2[200],
		    h3[200],
		    pos[1000];

    nom_label = (char **) malloc((size_t) __nblabelmax * sizeof(char *));
    for (i = 0; i < __nblabelmax; i++)
	nom_label[i] = NULL;
    nb = int_alloc1(__nblabelmax);
    for (i = 0; i < 20; i++)
	argv_com[i] = NULL;

    for (i = 0; i < nb_com; i++) {
        if (tr_label[i] == 0) {
/*-------------------------------------------------
    Traitement des lignes 'do...' et 'enddo...'
-------------------------------------------------*/
            j = 0;
            n = -1;
        
            while (j < nb_lignes[i]) {
                extrait_argv_com(i, &argc_com, j, argv_com);       

                if (comp(argv_com[0], "do") == 1) {
                    if (argc_com < 4) {
		        supprime_ligne_com(i,j);
                        j--;
                    }
                    else {
		        memset(h, 0, 200);
                        h[0] = _EVAL;
                        h[1] = ' ';
                        strcat(h, argv_com[1]);
                        strcat(h, "=");
                        strcat(h, argv_com[2]);
                        strcat(h, "-");
                        if (argc_com == 4)
			    strcat(h, "1");
                        else {
                            strcat(h, "(");
			    strcat(h, argv_com[4]);
                            strcat(h, ")");
                        }
                        memset(h1, 0, 200);
                        h1[0] = 127;
                        v = h1 + 1;
                        n++;
                        sprintf(v, "%d:", n);

                        memset(h2, 0, 200);
                        h2[0] = _EVAL;
                        h2[1] = ' ';
                        strcat(h2, argv_com[1]);
		        strcat(h2, "=");
		        strcat(h2, argv_com[1]);
		        strcat(h2, "+");
                        if (argc_com == 4)
			    strcat(h2, "1");
                        else {
			    strcat(h2, "(");
			    strcat(h2, argv_com[4]);
			    strcat(h2, ")");
			}
                        memset(h3, 0, 200);
		        strcpy(h3, "if> ");
                        strcat(h3, argv_com[1]);
                        strcat(h3, "-");
                        strcat(h3, "(");
                        strcat(h3, argv_com[3]);
                        strcat(h3, ")");
		        strcat(h3, " ");
                        h3[strlen(h3)] = 127;
                        v = h3 + strlen(h3);
                        pos[n] = 0;
                        n++;
                        sprintf(v, "%d", n);
                        supprime_ligne_com(i, j);
                        insere_ligne_com(i, j, h);
                        insere_ligne_com(i, j + 1, h1);
                        insere_ligne_com(i, j + 2, h2);
                        insere_ligne_com(i, j + 3, h3);
                        j += 3;
	            }
                }

                if (comp(argv_com[0], "enddo") == 1) {
                    l = -1;

                    for (k = n - 1; k >= 0; k -= 2) {
		        if (pos[k] == 0) {
                            l = k; 
                            break;
                        }
		    }
                 
                    if (l == -1) {
		        supprime_ligne_com(i, j);
                        j--;
                    }
                    else {
		        memset(h, 0, 200);
                        strcpy(h, "goto ");
                        h[strlen(h)] = 127;
                        v = h + strlen(h);
                        sprintf(v, "%d", l);

                        memset(h1, 0, 200);
                        h1[0] = 127;
                        v = h1 + 1;
                        sprintf(v, "%d:", l + 1);
                        supprime_ligne_com(i, j);
                        insere_ligne_com(i, j, h);
                        insere_ligne_com(i, j + 1, h1);
                        pos[l] = 1;
                        j++;
                    }             
	        }

	        j++;
            }
/*-----------------------------------------------*/


/*-------------------------------------------------
    Determination des lignes contenant des labels
-------------------------------------------------*/
	    nb_label[i] = 0;
            j = 0; 

            while (j < nb_lignes[i]) {
                extrait_argv_com(i, &argc_com, j, argv_com); 

                if (argv_com[0][strlen(argv_com[0]) - 1] == ':') {
		    nb[nb_label[i]] = j;
                    nettoie(argv_com[0]);
                    if (nom_label[nb_label[i]] != NULL)
		        free(nom_label[nb_label[i]]);
                    nom_label[nb_label[i]] = ch_copy(argv_com[0]);
		    nb_label[i]++;

                    supprime_ligne_com(i, j);
                    j--;
                }

                j++;
            }
        
            tr_label[i] = 1;
            if (nb_label[i] > 0) {
		num_label[i] = (int *) malloc((size_t) nb_label[i] *
		    sizeof(int));
                for (k = 0; k < nb_label[i]; k++)
		    num_label[i][k] = nb[k];
            }
/*-----------------------------------------------*/


/*-------------------------------------------------
    traitement des 'goto...'
-------------------------------------------------*/
            j = 0;

            while (j < nb_lignes[i]) {
                extrait_argv_com(i, &argc_com, j, argv_com); 
                if (comp(argv_com[0], "goto") == 1) {
                    k = -1;
                    if (argc_com > 1) {

	                for (l = 0; l < nb_label[i]; l++) {
		            if (comp(nom_label[l], argv_com[1]) == 1) {
		                k = l;
		            }
                        }

                        if (k == -1) {
		            supprime_ligne_com(i, j);
			    j--;
			}
	                else {
		            free(ligne_com[i][j]);
                            ligne_com[i][j] = (char *)malloc(20 *
 				sizeof(char));
                            memset(ligne_com[i][j], 0, 20);
                            ligne_com[i][j][0] = _GOTO;
                            memset(h, 200, 0);
                            sprintf(h, " %d", k);
                            strcat(ligne_com[i][j], h);
	                }
                    }
                    else {
		        supprime_ligne_com(i, j);
                        for (k = 0; k < nb_label[i]; k++) 
			    if (num_label[i][k] > j)
				num_label[i][k]--;
			j--;
		    }
	        }

                j++;
            }
/*-----------------------------------------------*/


/*-------------------------------------------------
    traitement des 'if...'
-------------------------------------------------*/
            j = 0;

            while (j < nb_lignes[i]) {
                extrait_argv_com(i, &argc_com, j, argv_com); 
                if (comp(argv_com[0], "if>") == 1 || 
		    comp(argv_com[0], "if<") == 1 ||
		    comp(argv_com[0], "if=") == 1) {
                    if (argc_com < 3) {
		        supprime_ligne_com(i, j);
                        for (k = 0; k < nb_label[i]; k++) 
			    if (num_label[i][k] > j)
				num_label[i][k]--;
                        j--;
                    }
                    else {
                        l = -1;

		        for (k = 0; k < nb_label[i]; k++) {
			    if (comp(argv_com[2], nom_label[k]) == 1) 
			        l = k;
 		        }

                        if (l == -1) {
			    supprime_ligne_com(i, j);
                            for (k = 0; k < nb_label[i]; k++) 
			        if (num_label[i][k] > j)
				    num_label[i][k]--;
                            j--;
                        }
                        else {
			    memset(h, 0, 200);
                            if (comp(argv_com[0], "if>") == 1)
				h[0] = _IFGT;
                            else {
				if (comp(argv_com[0], "if<") == 1)
				    h[0] = _IFLT;
                                else 
				    h[0] = _IFEQ;
                            }
                            h[1] = ' ';
                            strcat(h, argv_com[1]);
                            memset(h1, 0, 200);
                            sprintf(h1, " %d", l);
                            strcat(h, h1);
			    if (argc_com > 3) {
                                l = -1;

			        for (k = 0; k < nb_label[i]; k++) {
			            if (comp(argv_com[2], 
					nom_label[k]) == 1) 
			                l = k;
  		                }
  
                                if (l >= 0) {
			            memset(h2, 0, 200);
                                    sprintf(h2, " %d", l);
                                    strcat(h, h2);
                                }
                            }

                            supprime_ligne_com(i, j);
                            insere_ligne_com(i, j, h);
                        }
                    }
                }
                j++;
            }
        } 
/*-----------------------------------------------*/
    }

    XFREE(nb);
    for (i = 0; i < __nblabelmax; i++) 
	if (nom_label[i] != NULL)
	    free(nom_label[i]);
    free(nom_label);
    for (i = 0; i < 20; i++)
	if (argv_com[i] != NULL)
	    free(argv_com[i]);
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Suppression de la ligne j du programme i
-------------------------------------------------------------------*/
void
supprime_ligne_com(int i, int j) 
{
    int 	    k;

    free(ligne_com[i][j]);
    for (k = j + 1; k < nb_lignes[i]; k++)
	ligne_com[i][k - 1] = ligne_com[i][k];
    nb_lignes[i]--;
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Insertion d'une ligne du programme i, a la ligne j
-------------------------------------------------------------------*/
void
insere_ligne_com(int i, int j, char *h) {
    int 	    k;
     
    for (k = nb_lignes[i]; k > j; k--)
	ligne_com[i][k] = ligne_com[i][k - 1];
    ligne_com[i][j] = ch_copy(h);
    nb_lignes[i]++;
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Extraction des arguments d'une ligne de programme
-------------------------------------------------------------------*/
void 
extrait_argv_com(int i_com, int *argc_com, int iw, char *argv_com[]) 
{
    int		    ind,
		    k,
		    l,
                    j,
		    slen0;
    char	   *c;

    c = ligne_com[i_com][iw];
    *argc_com = 0;
    j = -1;
    ind = 0;
    k = -1;
    slen0 = strlen(c);
         
    while (j < slen0) {
        j++;
            
        if (j != slen0 && c[j] != ' ') {
	    if (ind == 0) {
	        argc_com[0]++;
		k = -1;
                ind = 1;
            }
	    if (*argc_com <= 20) {
                hcom[++k] = c[j];
            }
        }
	else {
	    ind = 0;
	    if (*argc_com > 0 && k >= 0) {
                l = *argc_com - 1;
                if (argv_com[l] != NULL)
		    free(argv_com[l]);
                argv_com[l] = (char *) malloc((size_t)(k + 2) * 
		    sizeof(char));
                memcpy(argv_com[l], hcom, k + 1);
                argv_com[l][k + 1] = 0;
	    }
	}
    }
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Teste si un nom de commande a deja ete utilise
-------------------------------------------------------------------*/
int
exist_com(char *nom)
{
    int		    i;

    for (i = 0; i <= nb_commandes; i++) 
 	if (comp(names[i], nom) == 1)
	    return 1;
    for (i = 0; i < nb_com; i++)
	if (comp(nom_com[i], nom) == 1)
	    return 1;
    return 0;
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Commande de destruction d'un programme. Syntaxe :
	delprog <nom>
    ou <nom> est le nom du programme.
-------------------------------------------------------------------*/
int
delprog_cmd(int argc, char *argv[])
{
    int 	    i,
                    j,
		    k;
     
    j = -1;
    for (i = 0; i < nb_com; i++)
	if (comp(nom_com[i], argv[1]) == 1)
	    j = i;
    if (j == -1) {
	err_mess(28);
        return 1;
    }

    for (i = j; i < nb_com - 1; i++) {
	for (k = 0; k < nb_lignes[i + 1]; k++) {
	    if (k < nb_lignes[i]) {
		free(ligne_com[i][k]);
                ligne_com[i][k] = NULL;
            }
            ligne_com[i][k] = ch_copy(ligne_com[i + 1][k]);
        }

        for (k = nb_lignes[i + 1]; k < nb_lignes[i]; k++) {
	    free(ligne_com[i][k]);
            ligne_com[i][k] = NULL;
	}

        nb_lignes[i] = nb_lignes[i + 1];
        sil_com[i] = sil_com[i + 1];
        free(nom_com[i]);
        nom_com[i] = ch_copy(nom_com[i + 1]);
        nb_label[i] = nb_label[i + 1];
        nb_par[i] = nb_par[i + 1];
        for (k = 0; k < __nmode_fonc; k++)
	    mode_com_int[i][k] = mode_com_int[i + 1][k];
        free(num_label[i]);
        num_label[i] = (int *) malloc((size_t) nb_label[i] * sizeof(int));
        for (k = 0; k < nb_label[i]; k++)
	    num_label[i][k] = num_label[i + 1][k];
    }

    nb_com--;

    for (k = 0; k < nb_lignes[nb_com]; k++) {
	free(ligne_com[nb_com][k]);
        ligne_com[nb_com][k] = NULL;
    }
    nb_lignes[nb_com] = 0;
    sil_com[nb_com] = 0;
    par_com[nb_com] = 0;
    free(nom_com[nb_com]);
    nom_com[nb_com] = NULL;
    nb_label[nb_com] = 0;
    free(num_label[nb_com]);
    for (k = 0; k < __nmode_fonc; k++)
	mode_com[nb_com][k] = 0;
    tr_label[nb_com] = 0;
    return 0;
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
-------------------------------------------------------------------*/
FILE *
fmemopen(void *xg, int nb, char *f)
{
    char	   *c;
    int		    i;
    FILE	   *s;

    s = tmpfile();
    c = (char *) xg;
    for (i = 0; i < nb; i++) 
	fwrite(&c[i], 1, 1, s);
    rewind(s);
    return s;
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Decodage du fichier d'initialisation
-------------------------------------------------------------------*/
char *
__Xdecode(char K[], int nb, char *inverse) 
{
    int		    i,
		    j;
    char	   *C;

    C = (char *) malloc((size_t) nb * sizeof(char));

    for (i = 0; i < nb; i++) {
        j = (int) K[i];
        if (j < 0)
	    j += 256;
        C[i] = inverse[j];
    }

    return C;
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
-------------------------------------------------------------------*/
char 
__chx(int i)
{
    if (i <= 128)
	return (char) i;
    else
	return (char)(i - 256);
}
/*-----------------------------------------------------------------*/




/*-------------------------------------------------------------------
-------------------------------------------------------------------*/
void
__perms(char *direct, char *inverse)
{
    int		    i,
		    j,
		    j0,
		    n,
		    x[256],
                    e[256];

    for (i = 0; i < 255; i++) {
	x[i] = (i * _P_MULT) % _PRIME_C;
	e[i] = 0;
    }

    for (i = 0; i < 255; i++) {
	n = -1;
        j0 = 0;

	for (j = 0; j < 255; j++) {
	    if (e[j] == 0) {
		if (x[j] > n) {
		     j0 = j;
                     n = x[j];
		}
	    }
	}

        e[j0] = 1;
	direct[i] = __chx(j0);
	inverse[j0] = __chx(i);	
    }
}
/*-----------------------------------------------------------------*/
