/*
	File:	  go.c
	Author:   Ben Bederson
	Date:	  April, 1988
	Function: Tests Hercules graphics routines
		  Examples of how to use routines

	Needs data files s1, s2, s3, and s4.

	Compile with large model (/AL) for use with graphics routines.
*/
#include <stdio.h>
#include <malloc.h>
#include "graphics.h"

struct shape_type shape;
struct shape_type shape1;
struct shape_type shape2;
struct shape_type shape3;
struct shape_type shape4;

main(argc,argv)
int argc;
char *argv[];
{
  int i,j,k;
  int m;
  int dir;
  int temp;
  int tempx,tempy;
  int att,chr;

  read_shape("s1",&shape);
  graphics();
  fill_screen();
  grcls();
  line(0,0,719,0);	/* sides of screen */
  line(0,0,0,347);
  line(719,0,719,347); /* top and bottom of screen */
  line(0,347,719,347);
  getch();
  draw(shape,16,300,WHITE);
  for (j=1; j<=2; j++) {
    for (i=16; i<600; i+=8) {
      shift_right_block(shape,i,300);
      if (argc > 3) getch();
    }
    for (k=300; k>50; k-=8) {
      shift_up_block(shape,i,k);
      if (argc > 3) getch();
    }
    for (m=i; m>16; m-=8) {
      shift_left_block(shape,m,k);
      if (argc > 3) getch();
    }
    for (i=k; i<300; i+=8) {
      shift_down_block(shape,m,i);
      if (argc > 3) getch();
    }
  }
  draw(shape,m,i,XOR);
  getch();
  read_shape("s1",&shape1);
  read_shape("s2",&shape2);
  read_shape("s3",&shape3);
  read_shape("s4",&shape4);
  draw_block(shape1,16,304,XOR);
  j = 2;
  dir = 1;
  for (i=16; i<=600; i+=8) {
    switch(j) {
      case 1:
	draw_block(shape1,i+8,304,XOR);
	draw_block(((dir == 1) ? shape1 : shape2),i,304,XOR);
	break;
      case 2:
	draw_block(shape2,i+8,304,XOR);
	draw_block(((dir == 1) ? shape1 : shape3),i,304,XOR);
	break;
      case 3:
	draw_block(shape3,i+8,304,XOR);
	draw_block(((dir == 1) ? shape2 : shape4),i,304,XOR);
	break;
      case 4:
	draw_block(shape4,i+8,304,XOR);
	draw_block(((dir == 1) ? shape3 : shape4),i,304,XOR);
	break;
    }
    j += dir;
    if (j > 4) {
      j = 4;
      dir *= -1;
    }
    else if (j < 1) {
      j = 1;
      dir *= -1;
    }
    if (argc > 2) getch();
  }
  text();
}

read_shape(filename,shape)
char *filename;
struct shape_type *shape;
{
  int i;
  int j;
  int temp;
  FILE *fp;

  fp = fopen(filename,"r");
  if (!fp) {
    text();
    printf("Error opening %s\n",filename);
    exit(1);
  }
  fscanf(fp,"%d%d",&((*shape).x),&((*shape).y));
  (*shape).shape_array = (char *)malloc((*shape).x * (*shape).y);
  if ((*shape).shape_array == 0) {
    text();
    printf("Error: can't malloc for shape\n");
    exit(1);
  }
  for (j=0; j<(*shape).y; j++) {
    for (i=0; i<(*shape).x; i++) {
      fscanf(fp,"%x",&temp);
      (*shape).shape_array[j*(*shape).x + i] = (char)(temp & 0xff);
    }
  }
  fclose(fp);
}
