/* x.h                    freeware                  xhunga@tiscali.fr  */


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void eqNorm(
double c,
double (*P_f)(double x),
double (*PDf)(double x)
)
{
double a;
double b;

a =    (-1/ ((*PDf)(c)) );
b =  -(-1/((*PDf)(c))) * c + ((*P_f)(c));

 printf(" %0.3lf*x %+0.3lf = 0",a ,b);
}


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void gplt_Norm(
   int xmin,
   int xmax,
   int ymin,
   int ymax,
double c,
  char   fEQ[TXT_EQ],
double (*P_f)(double x),
double (*PDf)(double x))
{
double a;
double b;
double t;

char    FPa[FILENAME] = "P";

FILE   *fp;
FILE   *fq;

        fp = fopen("f_Df.plt","w");
        fq = fopen(FPa,   "w");


fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n\n");
fprintf(fp," set zeroaxis\n\n");

fprintf(fp," plot [%d:%d] [%d:%d] ",xmin,xmax,ymin,ymax);
fprintf(fp,"%s",fEQ);
fprintf(fp,", ");

a =  (*PDf)(c);
b =(-(*PDf)(c)* c + (*P_f)(c));
fprintf(fp," %0.6lf*x %+0.6lf", a, b);
fprintf(fp,", ");

a =   (-1/((*PDf)(c)));
b =  -(-1/((*PDf)(c))) * c + ((*P_f)(c));
fprintf(fp," %0.6lf*x %+0.6lf", a, b);
fprintf(fp,", ");

fprintf(fp," \"%s\" lt 1 ",FPa);
fprintf(fp,"\n\n");
fprintf(fp," reset");

t = ((*P_f)(c));
fprintf(fq," %0.6lf  %0.6lf \n",c,t);

 fclose(fp);
 fclose(fq);
}


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void gplt_NormA(
   int xmin,
   int xmax,
   int ymin,
   int ymax,
double amin,
double amax,
double astep,
  char   fEQ[TXT_EQ],
double (*P_f)(double x),
double (*PDf)(double x)
)
{
double a;
double b;
double t;

   int n;
double c;

char    FPa[FILENAME] = "P";

FILE   *fp;
FILE   *fq;

        fp = fopen("f_Df.plt","w");
        fq = fopen(FPa,   "w");

fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n\n");
fprintf(fp," set zeroaxis\n\n");

for(c = amin; c<amax; c +=astep)
{
fprintf(fp," plot [%d:%d] [%d:%d] ",xmin,xmax,ymin,ymax);
fprintf(fp,"%s",fEQ);
fprintf(fp,", ");

a =  (*PDf)(c);
b =(-(*PDf)(c)* c + (*P_f)(c));
fprintf(fp," %0.6lf*x %+0.6lf", a, b);
fprintf(fp,", ");

a =   (-1/((*PDf)(c)));
b =  -(-1/((*PDf)(c))) * c + ((*P_f)(c));
fprintf(fp," %0.6lf*x %+0.6lf", a, b);
fprintf(fp,", ");

fprintf(fp," \"%s\" lt 1 ",FPa);
fprintf(fp,"\n pause 1\n\n");

t = ((*P_f)(c));
fprintf(fq," %0.6lf  %0.6lf \n",c, t);
}

fprintf(fp," reset");

 fclose(fp);
 fclose(fq);
}


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void gplt_Norm_xy(
   int xmin,
   int xmax,
   int ymin,
   int ymax,
double c,
  char   fEQ[TXT_EQ],
double (*P_f)(double x),
double (*PDf)(double x)
)
{
double a;
double b;
double t;

char    FPa[FILENAME] = "P";
char     FA[FILENAME] = "A";
char     FB[FILENAME] = "B";

FILE   *fp;
FILE   *fq;
FILE   *fr;
FILE   *fs;

        fp = fopen("f_Df.plt","w");
        fq = fopen(   FPa,"w");
        fr = fopen(   FA,"w");
        fs = fopen(   FB,"w");


fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n");
fprintf(fp," set zeroaxis\n\n");
fprintf(fp," plot [%d:%d] [%d:%d] ",xmin,xmax,ymin,ymax);
fprintf(fp,"%s",fEQ);
fprintf(fp,", ");

a =  (*PDf)(c);
b =(-(*PDf)(c)* c + (*P_f)(c));
fprintf(fp," %0.6lf*x %+0.6lf", a, b);
fprintf(fp,", ");

a =   (-1/((*PDf)(c)));
b =  -(-1/((*PDf)(c))) * c + ((*P_f)(c));
fprintf(fp," %0.6lf*x %+0.6lf", a, b);
fprintf(fp,", ");

fprintf(fp," \"%s\" lt 1 ",FPa);
fprintf(fp,", ");
fprintf(fp," \"%s\" lt 1 ",FA);
fprintf(fp,", ");
fprintf(fp," \"%s\" lt 1 ",FB);
fprintf(fp,"\n\n");
fprintf(fp," reset");

t = ((*P_f)(c));
fprintf(fq," %0.6lf  %0.6lf\n", c, t);

t = c+((*P_f)(c)) * ((*PDf)(c));
fprintf(fr," %0.6lf %0.6lf", t, 0.);

t = ((*P_f)(c)) + c / ((*PDf)(c));
fprintf(fs," %0.6lf %0.6lf",0., t);

 fclose(fp);
 fclose(fq);
 fclose(fr);
 fclose(fs);
}


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void gplt_NormPx(
   int xmin,
   int xmax,
   int ymin,
   int ymax,
double c,
  char   fEQ[TXT_EQ],
double (*P_f)(double x),
double (*PDf)(double x)
)
{
double a;
double b;
double t;

char    FPA[FILENAME] = "PA";

FILE   *fp;
FILE   *ft;

        fp = fopen("f_Df.plt","w");
        ft = fopen(  FPA,"w");

fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n");
fprintf(fp," set zeroaxis\n\n");
fprintf(fp," plot [%d:%d] [%d:%d] ",xmin,xmax,ymin,ymax);
fprintf(fp,"%s",fEQ);
fprintf(fp,", ");

a =  (*PDf)(c);
b =(-(*PDf)(c)* c + (*P_f)(c));
fprintf(fp," %0.6lf*x %+0.6lf", a, b);
fprintf(fp,", ");

a =   (-1/((*PDf)(c)));
b =  -(-1/((*PDf)(c))) * c + ((*P_f)(c));
fprintf(fp," %0.6lf*x %+0.6lf lt 9", a, b);
fprintf(fp,", ");

fprintf(fp," \"%s\" with linesp lt 3 ",FPA);
fprintf(fp,"\n\n");
fprintf(fp," reset");

t = ((*P_f)(c));
fprintf(ft," %0.6lf %0.6lf\n", c, t);

t =   c + ((*P_f)(c))*((*PDf)(c));
fprintf(ft," %0.6lf %0.6lf", t,0.);

 fclose(fp);
 fclose(ft);
}


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void gplt_NormPy(
   int xmin,
   int xmax,
   int ymin,
   int ymax,
double c,
  char   fEQ[TXT_EQ],
double (*P_f)(double x),
double (*PDf)(double x)
)
{
double a;
double b;
double t;

char    FPB[FILENAME] = "PB";
FILE   *fp;
FILE   *ft;

        fp = fopen("f_Df.plt","w");
        ft = fopen(  FPB,"w");

fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n");
fprintf(fp," set zeroaxis\n\n");
fprintf(fp," plot [%d:%d] [%d:%d] ",xmin,xmax,ymin,ymax);
fprintf(fp,"%s",fEQ);
fprintf(fp,", ");

a =  (*PDf)(c);
b =(-(*PDf)(c)* c + (*P_f)(c));
fprintf(fp," %0.6lf*x %+0.6lf", a, b);
fprintf(fp,", ");

a =   (-1/((*PDf)(c)));
b =  -(-1/((*PDf)(c))) * c + ((*P_f)(c));
fprintf(fp," %0.6lf*x %+0.6lf lt 9", a, b);
fprintf(fp,", ");


fprintf(fp," \"%s\" with linesp lt 3 ",FPB);
fprintf(fp,"\n\n");
fprintf(fp," reset");

t = ((*P_f)(c));
fprintf(ft," %0.6lf  %0.6lf\n", c, t);

t = ((*P_f)(c)) + c/((*PDf)(c));
fprintf(ft," %0.6lf %0.6lf", 0., t);

 fclose(fp);
 fclose(ft);
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void gplt_NormxM(
   int xmin,
   int xmax,
   int ymin,
   int ymax,
double c,
  char   fEQ[TXT_EQ],
double (*P_f)(double x),
double (*PDf)(double x)
)
{
double a;
double b;
double t;

char    FPA[FILENAME] = "PA";
char    FAM[FILENAME] = "AM";
FILE   *fp;
FILE   *ft;
FILE   *fr;

        fp = fopen("f_Df.plt","w");
        ft = fopen(  FPA,"w");
        fr = fopen(  FAM,"w");

fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n");
fprintf(fp," set zeroaxis\n\n");
fprintf(fp," plot [%d:%d] [%d:%d] ",xmin,xmax,ymin,ymax);
fprintf(fp,"%s",fEQ);
fprintf(fp,", ");

a =  (*PDf)(c);
b =(-(*PDf)(c)* c + (*P_f)(c));
fprintf(fp," %0.6lf*x %+0.6lf", a, b);
fprintf(fp,", ");

a =   (-1/((*PDf)(c)));
b =  -(-1/((*PDf)(c))) * c + ((*P_f)(c));
fprintf(fp," %0.6lf*x %+0.6lf lt 9", a, b);
fprintf(fp,", ");

fprintf(fp," \"%s\" with linesp lt 3 ",FPA);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 4 ",FAM);
fprintf(fp,"\n\n");
fprintf(fp," reset");

t =            ((*P_f)(c));
fprintf(ft," %0.6lf %0.6lf\n", c, t);

t =  c+((*P_f)(c))*((*PDf)(c));
fprintf(ft," %0.6lf %0.6lf", t, 0.);

t = c+((*P_f)(c))* ((*PDf)(c));
fprintf(fr," %0.6lf %0.6lf\n", t, 0.);


fprintf(fr," %0.6lf %0.6lf  ",  c, 0.);

 fclose(fp);
 fclose(ft);
 fclose(fr);
}


