/*         .c                       freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
double f(
double x)
{
 return(       sqrt(x));
}
char  feq[] = " sqrt(x)";
/* -------------------------------------------------------------------------- */
double Df(
double x)
{
 return(  (1.0/2.0) * (1.0/(sqrt(x))) );
}
char Dfeq[] = " (1.0/2.0)*(1.0/(sqrt(x)))";
/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */

/* --------------------------------- MAIN ----------------------------------- */
int main(void)
{
double (*Pfunct)     (double x);
double (*PfunctDeriv)(double x);

double c = 0.4;
double t;
/*-------------------------------- PROGRAM ---------------------------------- */
 Pfunct      =  f;
 PfunctDeriv = Df;

 clrscrn();
 printf("  f : x-> %s\n\n", feq);
 printf(" Df : x-> %s\n\n",Dfeq);

 printf("\n\n With c = %0.3lf, the equation of the tangent is :\n\n",c);
 printf("       Df(c) (x-c) + f(c) = ");
 eq_Tan(  c,
       (*Pfunct),
       (*PfunctDeriv)
       );

 printf("\n\n the equation of the  normal is :\n\n");
 printf("    -1/Df(c) (x-c) + f(c) =");
 eqNorm(  c,
       (*Pfunct),
       (*PfunctDeriv)
       );
 printf("\n\n");
 getchar();

 clrscrn();
 printf(" Find PA, the length of the normal from P to the x axis.\n\n");

 t =  ((*Pfunct)(c));
 printf(" P(%6.3lf, %6.3lf)         -> P(a, f(c))         \n", c, t);

 t = c+((*Pfunct)(c))*((*PfunctDeriv)(c));
 printf(" A(%6.3lf, %6.3lf)         -> A(c+f(c) Df(c), 0)\n\n", t, 0.);

 t = ((*Pfunct)(c))* sqrt(1+pow(((*PfunctDeriv)(c)),2));
 printf(" PA = %6.3lf               -> f(c) sqrt( 1 + Df(c)**2 )", t);

    gplt_NormPx(-1,      /* xmin  plot [xmin:xmax] [ymin:ymax] */
                 3,      /* xmax  */
                -1,      /* ymin  */
                 2,      /* ymax  */
                 c,
               feq,
         (*Pfunct),
         (*PfunctDeriv)
              );

 printf("\n\n To see the result in Gnuplot (gp373w32.exe) :           \n\n");
 printf("  * open the file f_Df.plt with Gnuplot.\n");

 printf("\n Press return to continue");
 getchar();

 return 0;
}

