;
;  Downloaded from BIX
;
;=========================
;tech.notes/pc.code #29, from pmaupin, 3407 chars, Sat Jun  4 22:40:45 1988
;--------------------------
;TITLE: Finding DOS's master environment pointer
;This is a fragment of code that my SD.COM program uses to find
;the environment.  This fragment is different than most ways of
;finding the environment, in that it finds the MASTER environment block,
;not the current process's parent's environment.

;This is useful in some cases, and has the added advantage that
;it does NOT behave differently when executing under CodeView,
;so you do NOT have to hard-code your system's DOS environment address
;into your program in order to debug it.

; Modified by JXL 9/3/88:
;
;	Name changed to findenv.
;
;	Changed to a FAR proc.  Segment-modeled for MSC or TC large mem model
;
;	Returns the segment-pointer to BLOCK HEADER OF the master environment
;	in AX, thus making it an int func for calling by C.
;
;	Returns NULL if the Master environment cannot apparently
;	be found.
;
;	Saves and restores all registers.
;
;	Makes no assumption about the initial contents of any register.

findenv_text segment word public 'code'
	assume cs:findenv_text

EnvPtr             EQU       2CH       ; Offset in PSP

CommandInterrupt   EQU       2EH       ; entry point into first Command.Com
                                       ; through interpreter

DosSegPtr          EQU       CommandInterrupt * 4 + 2


; FindEnvironment is passed:

;   DS should point to program PSP

;	JXL mod: NO! not passed anything at all.

; FindEnvironment returns:

;   ES points to master environment block, or program's copy if couldn't
;              find the master.

;	JXL mod: returns 0 if couldn't find master.
;	JXL mod: restores ES; returns segment of BLOCK HEADER in AX
;			 if master is found.

;   CX is length of block, or 0 if couldn't find the master.

;	JXL mod: does not return the length; CX is restored.

; FindEnvironment destroys:

;   AX, SI

;	JXL mod: does not destroy anything except AX.

public			_findenv
_findenv            PROC  FAR 
				push es
				push si
				push cx
                   xor   si,si                ; Point to segment 0
                   mov   es,si
                   mov   si, word ptr es:[DosSegPtr]
                   mov   ax,si
                   call  VerifyBlock          ; make sure we've found COMMAND
                   jnz   GotBlock             ; jump if not a good block --

                   mov   ax,es:[EnvPtr+10h]   ; get COMMAND's environment ptr
                   or    ax,ax                ; jump if COMMAND has a
                   jnz   MaybeGoodBlock       ; subsidiary environment

                   mov   ax,si                ; If no subsidiary, just use
                   add   ax,cx                ; the allocation block
                   inc   ax                   ; immediately after COMMAND

MaybeGoodBlock:    call  VerifyBlock          ; verify that we have a good
                                              ; one, one way or another
GotBlock:
				pop cx
				pop si
				pop es
                   ret


; VerifyBlock tries to insure that we're pointing to a valid DOS
; allocation block.  If not, returns the current process's environment
; block.  [JXL mod: returns 0 in AX instead]


VerifyBlock        PROC  NEAR
                   dec   ax                      ; get block header into ES
                   mov   es,ax
                   cmp   byte ptr es:[0],04Dh    ; make sure signature is valid
                   jnz   UseCurrent
                   cmp   word ptr es:[1],si      ; make sure owner is valid
                   jnz   UseCurrent
				mov cx,word ptr es:[3]			; retrieve the length
                   ret

UseCurrent:        mov   ax,0                    ; set failure
                   ret
VerifyBlock        ENDP

_findenv           ENDP
findenv_text		ends

					END
