
/*	ENVUTIL.C	*/

/*
	Written by OPENetwork 1988.
	Donated by OPENetwork to the public domain.
	Author: John Lowenthal (BIX: jlowenthal)
*/

/*
	Utilities for manipulating the Master (Command-level)
	Environment (or any other copy of the environment you want).

	Compiled with: Turbo C, Large Model
	Will compile with MSC 5.x with no changes except for perhaps
	the #include's of compiler-supplied headers.
	
*/

#include	<stdlib.h> 
#include	<string.h>
#include	<process.h>
#include	<dos.h>
#include	<stddef.h>
#include	"envutil.h"

/*
	In all of the following, the "seg" parameter is the segment
	of the environment data, not the segment of the allocated-block
	header that precedes it.
*/

/*
	Function: envavail()
	
	Get amount of available space in the environment.
	
	int envavail(unsigned seg);
	
*/

int envavail(unsigned seg)

{

char *datbase = MK_FP(seg,0);
char *lenptr;
int  totlen;
int  used;
int  entlen;
char *datscan;
unsigned hdrseg;

	for (datscan = datbase, used = 1;
		 *datscan;
		 datscan += entlen, used += entlen)
	{
		entlen = strlen(datscan) + 1;
	}
	hdrseg = seg - 1;
	lenptr = MK_FP(hdrseg,3);
	totlen = *((int *)lenptr) << 4;
	return(totlen - used);
	
}

/*
	Function: envempty()
	
	Get address of empty space in the environment (null string ptr).
	
	char *envempty(unsigned seg);
	
*/

char *envempty(unsigned seg)

{

char *datbase = MK_FP(seg,0);
int  entlen;
char *datscan;

	for (datscan = datbase;
		 *datscan;
		 datscan += entlen)
	{
		entlen = strlen(datscan) + 1;
	}
	return(datscan);
	
}

/*
	Function: envrmsz()
				 
	Get the length of environment data from a given point to the
	end of the environment.
	
	int envrmsz(char *the_point);
	
*/

int envrmsz(char *the_point)

{

char *cp;
int len;
int entlen;

	for (cp = the_point, len = 1; *cp; cp += entlen, len += entlen)
		entlen = strlen(cp) + 1;
	return(len);
	
}

/*
	Function: enventf()
	
	Find an entry in the environment.
	
	char *enventf(unsigned seg, char *varname);
	
	Returns NULL if not found.
	
*/

char *enventf(unsigned seg, char *varname)

{

char *datbase = MK_FP(seg,0);
char *cp;
int entlen;
char curent[160];
char *eqptr;

	for (cp = datbase; *cp; cp += entlen)
	{
		if ((entlen = strlen(cp) + 1) > 160)
			return(NULL);
		memcpy(curent,cp,entlen);
		if (! (eqptr = memchr(curent,'=',entlen)))
			return(NULL);
		*eqptr = 0;
		if (! stricmp(curent,varname))
			return(cp);
	}
	return(NULL);
	
}

/*
	Function: envvalf()
	
	Find the value of an entry in the environment.
	
	char *envvalf(unsigned seg, char *varname);
	
	Returns NULL if not found.
	
*/

char *envvalf(unsigned seg, char *varname)

{

char *entaddr;
char *eqptr;

	if (! (entaddr = enventf(seg,varname)))
		return(NULL);
		
	if (! (eqptr = strchr(entaddr,'=')))
		return(NULL);
		
	return(eqptr + 1);
	
}

/*
	Function: envdel()
	
	Delete an entry from the environment.
	
	int envdel(unsigned seg, char *varname);
	
	Returns: 1 = Success, 0 = not found.
	
*/

int envdel(unsigned seg, char *varname)

{

char *entaddr;
char *nextaddr;
int entlen;
int remlen;


	if (! (entaddr = enventf(seg,varname)))
		return(0);
		
	entlen = strlen(entaddr) + 1;
	nextaddr = entaddr + entlen;
	remlen = envrmsz(nextaddr);
	memmove(entaddr,nextaddr,remlen);
	nextaddr = envempty(seg);
	remlen = envavail(seg) + 1;
	memset(nextaddr,0,remlen);
	
	return(1);
	
}

/*
	Function: envadd()
	
	Add an entry to the environment, or change an existing entry.
	
	int envadd(unsigned seg, char *entry);
	
	Returns: 1 = OK, 0 = failure.
	
*/

int envadd(unsigned seg, char *entry)

{

char varname[50];
int varlen;
int entlen;
char *addpoint;
int avail;
char *eqptr;

	if (! (eqptr = strchr(entry,'=')))
		return(0);
	if (! (varlen = eqptr - entry))
		return(0);
	memcpy(varname,entry,varlen);
	varname[varlen] = 0;
	envdel(seg,varname);
	if (! *(eqptr + 1))
		return(1);
	entlen = strlen(entry) + 1;
	avail = envavail(seg);
	if (entlen + 1 > avail)
		return(0);
	addpoint = envempty(seg);
	memcpy(addpoint,entry,entlen);
	addpoint[entlen] = 0;
	return(1);
	
}
