/******************************************************************************
 * File: lzh.h
 * Desc: .lzh archive header include file
 * Date: 03/28/89
 *****************************************************************************/

/*

Attributes aren't displayed by lview but could be

Listing of archive : 'TEST3.LZH'

  Name          Original    Packed  Ratio   Date     Time   Attr Type  CRC
--------------  --------  -------- ------ -------- -------- ---- ----- ----
1                     12        12 100.0% 89-03-28  7:55:56 a--w -lh0- 3F2D
22                    12        12 100.0% 89-03-28  7:56:08 a--w -lh0- 3F2D
333                   12        12 100.0% 89-03-28  7:56:12 a--w -lh0- 3F2D
444                   12        12 100.0% 89-03-28  7:56:14 a--w -lh0- 3F2D
4444                  12        12 100.0% 89-03-28  7:56:16 a--w -lh0- 3F2D
55555                 12        12 100.0% 89-03-28  7:56:20 a--w -lh0- 3F2D
--------------  --------  -------- ------
     6 files          72        72 100.0%

000000  17 FC 2D 6C 68 30 2D 0C-00 00 00 0C 00 00 00 FC  ..-lh0-.........
000010  3E 7C 12 20 00 01 31 2D-3F 45 43 48 4F 20 69 73  >|. ..1-?ECHO is
000020  20 6F 6E 0D 0A 18 39 2D-6C 68 30 2D 0C 00 00 00   on...9-lh0-....
000030  0C 00 00 00 04 3F 7C 12-20 00 02 32 32 2D 3F 45  .....?|. ..22-?E
000040  43 48 4F 20 69 73 20 6F-6E 0D 0A 19 71 2D 6C 68  CHO is on...q-lh
000050  30 2D 0C 00 00 00 0C 00-00 00 06 3F 7C 12 20 00  0-.........?|. .
000060  03 33 33 33 2D 3F 45 43-48 4F 20 69 73 20 6F 6E  .333-?ECHO is on
000070  0D 0A 19 75 2D 6C 68 30-2D 0C 00 00 00 0C 00 00  ...u-lh0-.......
000080  00 07 3F 7C 12 20 00 03-34 34 34 2D 3F 45 43 48  ..?|. ..444-?ECH
000090  4F 20 69 73 20 6F 6E 0D-0A 1A AB 2D 6C 68 30 2D  O is on....-lh0-
0000A0  0C 00 00 00 0C 00 00 00-08 3F 7C 12 20 00 04 34  .........?|. ..4
0000B0  34 34 34 2D 3F 45 43 48-4F 20 69 73 20 6F 6E 0D  444-?ECHO is on.
0000C0  0A 1B E7 2D 6C 68 30 2D-0C 00 00 00 0C 00 00 00  ...-lh0-........
0000D0  0A 3F 7C 12 20 00 05 35-35 35 35 35 2D 3F 45 43  .?|. ..55555-?EC
0000E0  48 4F 20 69 73 20 6F 6E-0D 0A 00                 HO is on...     
0000F0  0A                                               .               

*/

typedef struct lzhlfh {			/* Local file header */
	char unknown1[2];		/* ? */
	char method[5];			/* compression method */
	long csize;			/* compressed size */
	long fsize;			/* uncompressed size */
	int ftime;			/* last mod file time (msdos format) */
	int fdate;			/* last mod file date */
	char fattr;			/* file attributes */
	char unknown2;			/* ? */
	char namelen;			/* filename length */
/*
	char *fname;			/* filename */
	int crc;			/* crc-16 */
*/
};

/*
	This information is not used by lview
*/

char *fattr[5] = {
	"---w",			/* type 0 */
	"---o",			/* type 1 - read only */
	"--hw",			/* type 2 */
	"-s-w",			/* type 4 */
	"a--w",			/* type 0x20 - archive */
};
