# This awk script calculates statistics on compression conversions.
# Interpretation: Convertion from x to y appears in row x, column y.
# Written by E.T.C

BEGIN {
# No. of compressors, compressors names:
  NOC = 10
  Name[0] = "arj"
  Name[1] = "sqz"
  Name[2] = "ha"
  Name[3] = "zip"
  Name[4] = "arc"
  Name[5] = "zoo"
  Name[6] = "hap"
  Name[7] = "hyp"
  Name[8] = "lzh"
  Name[9] = "hpk"
# Clear calculation tables.
  for (i = 0; i < NOC; i++)
    for (j = 0; j < NOC; j++) {
      In[Name[i], Name[j]] = 0
      Out[Name[i], Name[j]] = 0
    }
}
{
  if ($1 == "#") ;
  else {
    In[$1, $3] += ($2 + 0)
    Out[$1, $3] += ($4 + 0)
  }
}
END {
  printf ("COMP   | ");
  for (i = 0; i < NOC; i++)
    printf ("%3s  | ", Name[i])
  printf ("\n")
  printf ("-------|------|------|------|------|------|------|------|------|------|------|\n")
  for (i = 0; i < NOC; i++) {
    printf (" %3s   |", Name[i]);
    for (j = 0; j < NOC; j++) {
      tin = In[Name[i], Name[j]] + Out[Name[j], Name[i]]
      tout = Out[Name[i], Name[j]] + In[Name[j], Name[i]]
      if (tin == 0)
        printf ("  -   |")
      else
        printf ("%5.2f |", -100 * ((tout / tin) - 1))
    }
    printf ("\n")
  }
}

