"======================================================================
|
|   AbstractSocketImpl
|
|   $Revision: 1.7.5$
|   $Date: 2000/05/28 16:56:52$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


UnixStream subclass: #AbstractSocketImpl
	   instanceVariableNames: 'localAddress localPort '
	   classVariableNames: ''
	   poolDictionaries: ''
	   category: 'Sockets-Protocols'
!

!AbstractSocketImpl class methodsFor: 'constants'!

soLinger	^128!
soReuseAddr	^4!
soTimeout	^16r1006!
tcpNoDelay	^1!

sockDgram       ^2!
sockStream      ^1!
!

!AbstractSocketImpl methodsFor: 'abstract'!

bindTo: ipAddress port: port
    self subclassResponsibility
!

create
    self subclassResponsibility
!

getSockName
    self subclassResponsibility
!

optionAt: option level: level size: size
    self subclassResponsibility
!

optionAt: option level: level put: anObject
    self subclassResponsibility
! !

!AbstractSocketImpl methodsFor: 'accessing'!

localAddress
    ^localAddress
!

localPort
    ^localPort
! !

!AbstractSocketImpl methodsFor: 'socket options'!

soLinger
    | data |
    data := self
	optionAt: self class soLinger
	level: self class solSocket
	size: CInt sizeof * 2.

    (data intAt: 1) = 0 ifTrue: [ ^nil ].
    ^data intAt: CInt sizeof + 1
!

soLinger: linger
    | data |
    data := ByteArray new: CInt sizeof * 2.
    linger isNil ifFalse: [
	data at: 1 put: 1.
	data intAt: CInt sizeof + 1 put: linger
    ].
    self
	optionAt: self class soLinger
	level: self class solSocket
	put: data
!

soReuseAddr
    ^((self optionAt: self class soReuseAddr size: CInt sizeof) intAt: 1) > 0
!

soReuseAddr: aBoolean
    self
	optionAt: self class soReuseAddr
	level: self class solSocket
	put: aBoolean
!

soTimeout
    ^(self
	optionAt: self class soTimeout
	level: self class solSocket
	size: CInt sizeof) intAt: 1
!

soTimeout: timeout
    self
	optionAt: self class soTimeout
	level: self class solSocket
	put: timeout
!

tcpNoDelay
    ^((self
	optionAt: self class tcpNoDelay
	level: self class ipprotoTcp
	size: CInt sizeof) intAt: 1) > 0
!

tcpNoDelay: aBoolean
    | value |
    value := aBoolean ifTrue: [ 1 ] ifFalse: [ 0 ].
    self
	optionAt: self class tcpNoDelay
	level: self class ipprotoTcp
	put: value
! !

!AbstractSocketImpl methodsFor: 'private'!

makeByteArray: anObject
    | byteArray |
    (anObject class == ByteArray) ifTrue: [ ^anObject ].
    (anObject class == IPAddress) ifTrue: [ ^anObject asByteArray ].

    byteArray := ByteArray new: CInt sizeof.

    anObject == true	ifTrue: [ byteArray intAt: 1 put: 1 ].
    anObject isInteger	ifTrue: [ byteArray intAt: 1 put: anObject ].
    ^byteArray
!

hasBeenBound
    | port |
    port := ValueHolder new.
    localAddress := IPAddress fromSockAddr: self getSockName port: port.
    localPort := port value
! !


!AbstractSocketImpl methodsFor: 'private'!

nowDead
! !
