// Some DJGPP-specific stuff

#if defined(__DJGPP__)

/* Used for correct text/binary handling from the console.
   It's originally a WinNT thing, so we need to tell it what out functions
    are called. */
#define _setmode setmode
#define _fileno  fileno

/* Some declarations */
extern char* last_slash (const char*);
extern int   pathcmp (const char*, const char*);
extern void  djgpp_cvs_init(int*, char***);

/* Override some stuff (both for libdiff and CVS itself) */
#define SYSTEM_INITIALIZE(pargc,pargv) djgpp_cvs_init(pargc, pargv)

#undef filename_lastdirchar
#define filename_lastdirchar(filename) last_slash (filename)

#undef filename_cmp
#define filename_cmp(a, b) pathcmp (a, b)

// Define this to quote arguments to children. WinNT does this, but I don't
//  think we need or want it.
#define DJ_WANT_QUOTED_ARGS 0

// We don't have any kind of fork(), and cvs doesn't support spoon().
#undef HAVE_VFORK
#undef HAVE_FORK

#endif
