#! /bin/sh

UPX="upx --best"
DOCDIR=binutl-2.121
B_NAME=bnu2121b
A_NAME=bnu2121a

CURR=`pwd`
INST=`(cd ..; pwd)`/install.djg
test -d $INST || mkdir $INST

./djconfig.sh
make CFLAGS="-W -Wall -O2"
make install prefix=$INST

cd ../install.djg

mkdir gnu
mkdir gnu/$DOCDIR
cp -v $CURR/readme.DJGPP gnu/$DOCDIR/readme.dos
mkdir manifest
cp -v $CURR/$B_NAME.dsm manifest/
cp -v $CURR/$A_NAME.dsm manifest/
rm -f info/dir

$UPX bin/*.exe

#  Fixes info files generated by makeinfo to fit in
#  MS-DOS 8+3 filename limits
#
for file in info/*.info-*; do
	mv $file `echo $file | sed -e 's,info-,i,'`; 
done

for file in info/*.info; do
	echo $file
  	cat $file | \
	awk 'substr($0,1,9)=="Indirect:" { active=1; } \
	     substr($0,1,10)=="Tag Table:" { active=0; } \
	     { if (active) gsub("info-","i"); \
               print $0 }' > $file.new
        mv -f $file.new $file
done

echo "Converting man pages ..."

for x in `find man -type f -and -name '*.[1-9]*'`; do
    case $x in 
	man/man*)
	    echo `basename $x`
	    x1=`echo $x | sed -e 's,^man/,,g'`
            c1=`echo $x1 | sed -e 's,man\([1-9]\)/,cat\1/,g'`
            ginstall -d man/`dirname $c1`
	    ( cd man && groff -man -Tascii $x1 >$c1 )
            ;;
    esac
done

mv -v i386-pc-msdosdjgpp/lib/ldscripts lib
rm -fr i386-pc-msdosdjgpp/bin

echo '$B_NAME.zip - GNU Binutils 2.12.1 binary archive for DJGPP' >manifest/$B_NAME.ver
echo '$A_NAME.zip - GNU BFD library 2.12.1 binary archive for DJGPP' >manifest/$A_NAME.ver
echo '' >manifest/$B_NAME.mft
echo '' >manifest/$A_NAME.mft

for x in `find . -type f | sed -e 's:^\./::'` ; do
	case $x in
		man/man1/*) ;;
		*/readme.dos) echo $x >> manifest/$A_NAME.mft; echo $x >> manifest/$B_NAME.mft ;;
		info/bfd*|lib/*.a|lib/*.la|include/*.h|manifest/$A_NAME.*) echo $x >> manifest/$A_NAME.mft ;;
		*) echo $x >> manifest/$B_NAME.mft ;;
	esac
done

zip -9 $B_NAME.zip @manifest/$B_NAME.mft
zip -9 $A_NAME.zip @manifest/$A_NAME.mft
