"======================================================================
|
|   SharedQueue Method Definitions
|
|   $Revision: 1.7.5$
|   $Date: 2000/05/28 16:56:52$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Steve Byrne.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


Object subclass: #SharedQueue
       instanceVariableNames: 'queueSem valueReady queue'
       classVariableNames: ''
       poolDictionaries: ''
       category: 'Language-Processes'
!

SharedQueue comment: 
'My instances provide a guaranteed safe mechanism to allow for communication
between processes.  All access to the underlying data structures is
controlled with critical sections so that things proceed smoothly.' !



!SharedQueue class methodsFor: 'instance creation'!

new
    "Create a new instance of the receiver"
    ^self basicNew init
! !



!SharedQueue methodsFor: 'accessing'!

next
    "Wait for an object to be on the queue, then remove it and answer it"
    | result |
    valueReady wait.
    queueSem critical: [ result := queue removeFirst ].
    ^result
!

nextPut: value
    "Put value on the queue and answer it"
    queueSem critical: [ queue addLast: value ].
    valueReady signal.
    ^value
! !



!SharedQueue methodsFor: 'private'!

init
    queue := OrderedCollection new: 10.
    valueReady := Semaphore new.
    queueSem := Semaphore forMutualExclusion
! !
