I built the 3.79.2a1 pretest of GNU Make, and found the following
problems:

  - The ``reversed'' and ``non-reversed'' calls to setvbuf in main.c
    were backwards: the normal (ANSI/ISO) prototype of setvbuf has the
    buffer as the second argument.

  - There was some snafu with EOLs in dosbuild.bat: it has 2 ^M
    characters before each newline.  Curiously, configure.bat is
    correct.

  - Makefile.DOS and configh.DOS needed some tweaking.

Diffs to solve all those problems (with the exception of dosbuild.bat)
are below.  After applying those, the DJGPP port of Make builds okay
and passes all the regression tests.


2002-05-18  Eli Zaretskii  <eliz@is.elta.co.il>

	* Makefile.DOS.template: Tweak according to changes in the
	distribution.  Add back the dependencies of *.o files.

	* configh.dos.template: Synchronize with config.h.in.

	* main.c (main) [SETVBUF_REVERSED]: Switch the reversed and
	non-reversed calls to setvbuf.


--- main.c~0	2002-05-10 06:15:08.000000000 +0300
+++ main.c	2002-05-18 11:28:24.000000000 +0300
@@ -906,10 +906,10 @@ int main (int argc, char ** argv)
 
 #ifdef HAVE_SETVBUF
 # ifdef SETVBUF_REVERSED
-  setvbuf (stdout, (char *) 0, _IOLBF, BUFSIZ);
-# else	/* setvbuf not reversed.  */
   /* Some buggy systems lose if we pass 0 instead of allocating ourselves.  */
   setvbuf (stdout, _IOLBF, xmalloc (BUFSIZ), BUFSIZ);
+# else	/* setvbuf not reversed.  */
+  setvbuf (stdout, (char *) 0, _IOLBF, BUFSIZ);
 # endif	/* setvbuf reversed.  */
 #elif HAVE_SETLINEBUF
   setlinebuf (stdout);
--- configh.d~0	2002-05-13 17:58:38.000000000 +0300
+++ configh.dos	2002-05-18 11:22:12.000000000 +0300
@@ -2,12 +2,6 @@
 /* Many things are defined already by a system header.  */
 #include <sys/config.h>
 
-/* Name of this package (needed by automake) */
-#define PACKAGE "make"
-
-/* Version of this package (needed by automake) */
-#define VERSION "3.79.2a1"
-
 #if __DJGPP__ > 2 || __DJGPP_MINOR__ > 1
 
 /* Define if `sys_siglist' is declared by <signal.h>.  */
@@ -23,21 +17,33 @@
 
 #endif
 
+/* Use high resolution file timestamps if nonzero. */
+#define FILE_TIMESTAMP_HI_RES 0
+
+/* Define to 1 if you have `alloca', as a function or macro. */
+#define HAVE_ALLOCA 1
+
 /* Define if you have the fdopen function.  */
 #define HAVE_FDOPEN 1
 
-/* Define if you have sigsetmask.  */
-#define HAVE_SIGSETMASK 1
+/* Define to 1 if you have the `getgroups' function. */
+#define HAVE_GETGROUPS 1
 
 /* Define if you have the <memory.h> header file.  */
 #define HAVE_MEMORY_H 1
 
-/* Define if you have the memmove function.  */
-#define HAVE_MEMMOVE 1
-
 /* Define if you have the mkstemp function.  */
 #define HAVE_MKSTEMP 1
 
+/* Define to 1 if you have the `mktemp' function. */
+#define HAVE_MKTEMP 1
+
+/* Define to 1 if you have the `setlinebuf' function. */
+#define HAVE_SETLINEBUF 1
+
+/* Define to 1 if you have the `setvbuf' function. */
+#define HAVE_SETVBUF 1
+
 #define SCCS_GET "get"
 
 /* Define to `unsigned long' or `unsigned long long'
@@ -54,6 +60,33 @@
 #undef HAVE_VPRINTF
 #define HAVE_VPRINTF 1
 
+/* Name of the package */
+#define PACKAGE "make"
+
+/* Define to the address where bug reports for this package should be sent. */
+#define PACKAGE_BUGREPORT "bug-make@gnu.org"
+
+/* Define to the full name of this package. */
+#define PACKAGE_NAME "GNU make"
+
+/* Define to the full name and version of this package. */
+#define PACKAGE_STRING "GNU make 3.79.2a1"
+
+/* Define to the one symbol short name of this package. */
+#define PACKAGE_TARNAME "make"
+
+/* Define to the version of this package. */
+#define PACKAGE_VERSION "3.79.2a1"
+
+/* Define to 1 if the C compiler supports function prototypes. */
+#define PROTOTYPES 1
+
+/* Define to 1 if `sys_siglist' is declared by <signal.h> or <unistd.h>. */
+#define SYS_SIGLIST_DECLARED 1
+
+/* Version number of package */
+#define VERSION "3.79.2a1"
+
 /* Build host information. */
 #define MAKE_HOST "i386-pc-msdosdjgpp"
--- Makefile.D~0	2002-05-13 17:58:38.000000000 +0300
+++ Makefile.DOS	2002-05-18 10:52:46.000000000 +0300
@@ -1,7 +1,7 @@
 # -*-Makefile-*- template for DJGPP
 # Makefile.in generated automatically by automake 1.2 from Makefile.am
 
-# Copyright (C) 1994, 1995-1998, 1999 Free Software Foundation, Inc.
+# Copyright (C) 1994, 1995-1998, 1999, 2002 Free Software Foundation, Inc.
 # This Makefile.DOS is free software; the Free Software Foundation
 # gives unlimited permission to copy, distribute and modify it.
 
@@ -47,7 +47,11 @@
 NORMAL_UNINSTALL = :
 PRE_UNINSTALL = :
 POST_UNINSTALL = :
+EXEEXT = .exe
+OBJEXT = o
+
 AR = ar
+AWK = gawk
 CC = gcc
 CPP = gcc -E
 LIBOBJS =
@@ -60,7 +64,7 @@
 
 AUTOMAKE_OPTIONS = 1.2
 
-bin_PROGRAMS =	make
+bin_PROGRAMS =	make$(EXEEXT)
 
 make_SOURCES =	ar.c arscan.c commands.c default.c dir.c expand.c file.c function.c getopt.c getopt1.c implicit.c job.c main.c misc.c read.c remake.c rule.c signame.c variable.c version.c vpath.c remote-$(REMOTE).c
 # This should include the glob/ prefix
@@ -99,7 +103,7 @@
 COMPILE = $(CC) $(DEFS) $(INCLUDES) $(CPPFLAGS) $(CFLAGS)
 LINK = $(CC) $(CFLAGS) $(LDFLAGS) -o $@
 TEXI2DVI = texi2dvi
-TEXINFO_TEX = $(srcdir)/texinfo.tex
+TEXINFO_TEX = $(srcdir)/config/texinfo.tex
 INFO_DEPS = make.info
 DVIS = make.dvi
 TEXINFOS = make.texinfo
@@ -107,8 +111,7 @@
 MANS = $(man_MANS)
 
 NROFF = nroff
-DIST_COMMON =  README ABOUT-NLS AUTHORS COPYING ChangeLog INSTALL Makefile.am  Makefile.in NEWS acconfig.h aclocal.m4 alloca.c build.sh.in config.h.in  configure configure.in getloadavg.c gettext.c install-sh missing mkinstalldirs  stamp-h.in texinfo.tex
-
+DIST_COMMON =  README ABOUT-NLS AUTHORS COPYING ChangeLog INSTALL Makefile.am  Makefile.in NEWS acconfig.h aclocal.m4 alloca.c build.sh-in config.h-in  configure configure.in getloadavg.c
 
 DISTFILES = $(DIST_COMMON) $(SOURCES) $(HEADERS) $(TEXINFOS) $(EXTRA_DIST)
 
@@ -121,7 +124,7 @@
 default: all
 
 .SUFFIXES:
-.SUFFIXES: .S .c .dvi .info .o .ps .s .texi .texinfo .txi
+.SUFFIXES: .c .dvi .info .o .obj .ps .texinfo .tex
 
 mostlyclean-hdr:
 
@@ -153,17 +156,11 @@
 .c.o:
 	$(COMPILE) -c $<
 
-.s.o:
-	$(COMPILE) -c $<
-
-.S.o:
-	$(COMPILE) -c $<
-
 clean-noinstLIBRARIES:
 	-test -z "$(noinst_LIBRARIES)" || rm -f $(noinst_LIBRARIES)
 
 mostlyclean-compile:
-	-rm -f *.o *.exe make.new core
+	-rm -f *.$(OBJEXT) *$(EXEEXT) make.new core
 
 clean-compile:
 
@@ -172,7 +169,7 @@
 
 maintainer-clean-compile:
 
-make: $(make_OBJECTS) $(make_DEPENDENCIES)
+make$(EXEEXT): $(make_OBJECTS) $(make_DEPENDENCIES)
 	@command.com /c if exist make del make
 	@command.com /c if exist make.exe del make.exe
 	$(LINK) $(make_LDFLAGS) $(make_OBJECTS) $(make_LDADD) $(LIBS)
@@ -183,29 +180,19 @@
 
 DVIPS = dvips
 
-.texi.info:
-	$(MAKEINFO) $(srcdir)/$< -o ./$@
-
-.texi.dvi:
-	TEXINPUTS="$(srcdir);$$TEXINPUTS"    MAKEINFO='$(MAKEINFO) -I $(srcdir)' $(TEXI2DVI) $<
-
-.texi:
-	$(MAKEINFO) $(srcdir)/$< -o ./$@
-
 .texinfo.info:
-	$(MAKEINFO) $(srcdir)/$< -o ./$@
+	@command.com /c if exist make.info* del make.info*
+	@command.com /c if exist make.i* del make.i*
+	$(MAKEINFO) -I$(srcdir) $< -o ./$@
 
 .texinfo:
-	$(MAKEINFO) $(srcdir)/$< -o ./$@
+	@command.com /c if exist make.info* del make.info*
+	@command.com /c if exist make.i* del make.i*
+	$(MAKEINFO) -I$(srcdir) $< -o ./$@
 
 .texinfo.dvi:
 	TEXINPUTS="$(srcdir);$$TEXINPUTS"    MAKEINFO='$(MAKEINFO) -I $(srcdir)' $(TEXI2DVI) $<
 
-.txi.info:
-	$(MAKEINFO) $(srcdir)/$< -o ./$@
-
-.txi.dvi:
-	TEXINPUTS="$(srcdir);$$TEXINPUTS"    MAKEINFO='$(MAKEINFO) -I $(srcdir)' $(TEXI2DVI) $<
 
 .dvi.ps:
 	$(DVIPS) $< -o $@
@@ -544,30 +531,39 @@
 .NOEXPORT:
 
 # --------------- DEPENDENCIES
-#
-# dummy
-# dummy
-# dummy
-# dummy
-# dummy
-# dummy
-# dummy
-# dummy
-# dummy
-# dummy
-# dummy
-# dummy
-# dummy
-# dummy
-# dummy
-# dummy
-# dummy
-# dummy
-# dummy
-# dummy
-# dummy
-# dummy
-# dummy
-# dummy
-# dummy
-# dummy
+ar.o: ar.c make.h config.h gettext.h filedef.h dep.h glob/fnmatch.h
+arscan.o: arscan.c make.h config.h gettext.h
+commands.o: commands.c make.h config.h gettext.h dep.h filedef.h \
+	variable.h job.h commands.h
+default.o: default.c make.h config.h gettext.h rule.h dep.h filedef.h \
+	job.h commands.h variable.h
+dir.o: dir.c make.h config.h gettext.h glob/glob.h
+expand.o: expand.c make.h config.h gettext.h filedef.h job.h commands.h \
+	variable.h rule.h
+file.o: file.c make.h config.h gettext.h dep.h filedef.h job.h \
+	commands.h variable.h debug.h
+function.o: function.c make.h config.h gettext.h filedef.h variable.h \
+	dep.h job.h commands.h debug.h
+getopt.o: getopt.c config.h gettext.h getopt.h
+getopt1.o: getopt1.c config.h getopt.h
+implicit.o: implicit.c make.h config.h gettext.h rule.h dep.h filedef.h \
+	debug.h
+job.o: job.c make.h config.h gettext.h job.h debug.h filedef.h \
+	commands.h variable.h
+main.o: main.c make.h config.h gettext.h dep.h filedef.h variable.h \
+	job.h commands.h rule.h debug.h getopt.h
+misc.o: misc.c make.h config.h gettext.h dep.h debug.h
+read.o: read.c make.h config.h gettext.h glob/glob.h dep.h filedef.h \
+	job.h commands.h variable.h rule.h debug.h
+remake.o: remake.c make.h config.h gettext.h filedef.h job.h commands.h \
+	dep.h variable.h debug.h
+remote-stub.o: remote-stub.c make.h config.h gettext.h filedef.h job.h \
+	commands.h
+rule.o: rule.c make.h config.h gettext.h dep.h filedef.h job.h \
+	commands.h variable.h rule.h
+signame.o: signame.c make.h config.h gettext.h
+variable.o: variable.c make.h config.h gettext.h dep.h filedef.h job.h \
+	commands.h variable.h rule.h
+version.o: version.c config.h
+vpath.o: vpath.c make.h config.h gettext.h filedef.h variable.h
+
--- tests/scripts/features/errors.~	1999-09-14 04:03:34.000000000 +0200
+++ tests/scripts/features/errors	2002-05-18 11:51:52.000000000 +0300
@@ -40,7 +40,9 @@
 
 unlink("cleanit");
 $cleanit_error = `sh -c "$delete_command cleanit 2>&1"`;
-$delete_error_code = $? >> 8;
+# DJGPP port of Perl doesn't shift the exit code 8 bits to the left
+#$delete_error_code = $? >> 8;
+$delete_error_code = $?;
 
 # TEST #1
 # -------
