/* V.C.P. functions */
# include "vcpfunct.h"
/*****************************************************
	Erases the control from the screen and
        sets usable to False

       id = user defined id of the field

******************************************************/
void VCPCtlEraseControl(Word id)
{
	FormPtr fp;

	fp=FrmGetActiveForm();
	CtlEraseControl(FrmGetObjectPtr(fp, FrmGetObjectIndex(fp, id)));
}
/*****************************************************
	Draws the control 

       id = user defined id of the field

******************************************************/
void VCPCtlDrawControl(Word id)
{
	FormPtr fp;

	fp=FrmGetActiveForm();
	CtlDrawControl(FrmGetObjectPtr(fp, FrmGetObjectIndex(fp, id)));
}
/**************************************************
    emulates the itoa function

    convert a integer into a string

***************************************************/
void itoa(char *s, int n)
{
	long i, sign;

	if ((sign=n) <0) n=-n;
	i=0;
	do{
		s[i++]=n % 10 + '0';
	} while((n/=10)>0);
	if (sign<0) s[i++]='-';
	s[i]=0;
	VCPINTreverse(s);
}
/**************************************************************************/
# ifndef VCPINTREVERSE
# define VCPINTREVERSE 1
void VCPINTreverse(char *s)
{
	int c, i, j;
	for(i=0,j=StrLen(s)-1; i<j; i++,j--){
		c=s[i];
		s[i]=s[j];
		s[j]=c;
	}
}
# endif
/**************************************************************************/
/**************************************************
    emulates the ltoa function

    convert a long into a string

***************************************************/
void ltoa(char *s, long n)
{
	long i, sign;

	if ((sign=n) <0) n=-n;
	i=0;
	do{
		s[i++]=n % 10 + '0';
	} while((n/=10)>0);
	if (sign<0) s[i++]='-';
	s[i]=0;
	VCPINTreverse(s);
}
/**************************************************************************/
# ifndef VCPINTREVERSE
# define VCPINTREVERSE 1

void VCPINTreverse(char *s)
{
	int c, i, j;
	for(i=0,j=StrLen(s)-1; i<j; i++,j--){
		c=s[i];
		s[i]=s[j];
		s[j]=c;
	}
}
# endif
/**************************************************************************/
/*****************************************
    emulates the atoi function

    convert a string into an integer

******************************************/
int atoi(char *s)
{
	int rc=0;
	int t;
	for(t=0; t<StrLen(s); t++){
		if (isdigit(s[t])==FALSE) break;
		rc+=(int)s[t]-'0';
		rc=rc*10;
	}
	return(rc/10);
}
/**************************************************
    emulates the isdigit function

    test if an integer is between '0' and '9'

***************************************************/
int isdigit(int c)
{
	if(c>='0' && c<='9') return(TRUE);
	else return(FALSE);
}
/******************************************************

        Begin working with databases
        Initialize internal V.C.P.-fields

        Must be called as the FIRST VCPDb statement!!

*******************************************************/

void VCPDbBeginWork(void)
{
	
	VCPDbErrorFlag=0;
	VCPINTOpenFlag=FALSE;
}
/**************************************************************************/
# ifdef DEBUG

void VCPINTDbErrorDisplay(char *fname, long lnr)
{
int err;
char zwi2[64];
char zwi3[8];
char zwi[64];

	err=VCPDbErrorFlag;
	itoa(zwi, err);
	StrCat(zwi, ": unknown error");

/*
 * Pilot error codes
 */
if (err==dmErrInvalidDatabaseName) StrCopy(zwi, "dm Invalid database name");
if (err==dmErrAlreadyExists) StrCopy(zwi, "dm Database already exists");
if (err==dmErrCantFind) StrCopy(zwi, "dm Can't find DB");
if (err==dmErrCantOpen) StrCopy(zwi, "dm Can't open DB");
if (err==dmErrDatabaseOpen) StrCopy(zwi, "dm Database is open");
if (err==dmErrROMBased) StrCopy(zwi, "db DB is ROM based");
if (err==dmErrMemError) StrCopy(zwi, "dm Memory error");
if (err==dmErrNotValidRecord) StrCopy(zwi, "dm not a valid record");
if (err==dmErrWriteOutOfBounds) StrCopy(zwi, "dm Write out of bounds");
if (err==dmErrCorruptDatabase) StrCopy(zwi, "dm db corrupted");
if (err==dmErrIndexOutOfRange) StrCopy(zwi, "dm index out of range");
if (err==dmErrReadOnly) StrCopy(zwi, "dm db is readonly");
if (err==memErrCardNotPresent) StrCopy(zwi, "mem Card not present");
if (err==memErrChunkLocked) StrCopy(zwi, "mem Chunk locked");
if (err==memErrInvalidParam) StrCopy(zwi, "mem Invalid parameters");
if (err==memErrInvalidStoreHeader) StrCopy(zwi, "mem Invalid storage header");
if (err==memErrNotEnoughSpace) StrCopy(zwi, "mem Not enough space");
if (err==memErrRAMOnlyCard) StrCopy(zwi, "mem RAM only card");

/*
 * internal V.C.P. DB-Manager error codes
 */
if (err==VCPINTDBNOTFOUND) StrCopy(zwi, "V.C.P. db name not found");
if (err==VCPINTUNSUCCESSFULLOPEN) StrCopy(zwi, "V.C.P. unsuccessful open of db");
if (err==VCPINTDBNOTOPEN) StrCopy(zwi, "V.C.P. db is not open");
if (err==VCPINTRECNOTFOUND) StrCopy(zwi, "V.C.P. record not found");
if (err==VCPINTCOULDNOTINSERT) StrCopy(zwi, "V.C.P. could not insert record");
if (err==VCPINTCOULDNOTRESIZE) StrCopy(zwi, "V.C.P. could not resize record");
if (err==VCPINTONEDBISOPEN) StrCopy(zwi, "V.C.P. one db is already open");


	StrCopy(zwi2, "file=");
	StrCat(zwi2, fname);
	itoa(zwi3, lnr);
	StrCat(zwi2, "  line=");
	StrCat(zwi2, zwi3);
	VCPdebug("V.C.P. DB Manager", zwi2, zwi);
}
# endif
/**************************************************************************/
# ifndef DEBUG
	# define VCPINTDbErrorDisplay(x,y);
# endif
/*****************************************************
    Set the text of an editable field in the
    actual form.

    id = user defined id of the field
    *s = char pointer where the new text is located

    Example:
    ========
    VCPFldSetText(FLDRECORD, "New Record");

******************************************************/
void VCPFldSetText(Word id, char *s)
{
	FormPtr frmp;
	FieldPtr fldp;
	FieldAttrType fa;

	frmp=FrmGetActiveForm();
	fldp=FrmGetObjectPtr(frmp, FrmGetObjectIndex(frmp, id));
	FldGetAttributes(fldp, &fa);

	/* if editable, do insert, if not, set poiner */
	if (fa.editable == TRUE){
		FldDelete(fldp, 0, FldGetTextLength(fldp));
		FldInsert(fldp, s, StrLen(s));
	}
	else{
		FldSetTextPtr(fldp, s);
	}

	FldDrawField(fldp);
}
/*************************************************
     Get the text of a field on the
     active form.

     id = user defined id of the field
     *s = char pointer where the result goes

     Example:
     ========

     char erg[32];
     VCPFldGetText(FLDREC, erg);

**************************************************/
void VCPFldGetText(Word id, char *s)
{
	FormPtr frmp;
	FieldPtr fldp;

	frmp=FrmGetActiveForm();
	fldp=FrmGetObjectPtr(frmp, FrmGetObjectIndex(frmp, id));
	if (FldGetTextPtr(fldp)>NULL){
		StrCopy(s, FldGetTextPtr(fldp));
	}
	else{
		s[0]=0;
	}
}
/*****************************************************
    Sets the focus to a field

    id   = user defined id of the field

******************************************************/
void VCPFldSetFocus(Word id)
{
	FormPtr frmp;

	frmp=FrmGetActiveForm();
	FrmSetFocus(frmp, FrmGetObjectIndex(frmp, id));

}
/*****************************************************
    Set the editable flag of a field

    id   = user defined id of the field
    mode = TRUE or FALSE

******************************************************/
void VCPFldSetEditable(Word id, int mode)
{
	FormPtr frmp;
	FieldPtr fldp;
	FieldAttrType fa;

	frmp=FrmGetActiveForm();
	fldp=FrmGetObjectPtr(frmp, FrmGetObjectIndex(frmp, id));
	FldGetAttributes(fldp, &fa);
	fa.editable = mode;
	FldSetAttributes(fldp, &fa);

	FldDrawField(fldp);
}
/*****************************************************
    Set the underlined attribute of a field in the
    actual form.

    id = user defined id of the field
    val = TRUE or FALSE


******************************************************/
void VCPFldSetUnderlined(Word id, UInt val)
{
	FormPtr frmp;
	FieldPtr fldp;
	FieldAttrType fa;

	frmp=FrmGetActiveForm();
	fldp=FrmGetObjectPtr(frmp, FrmGetObjectIndex(frmp, id));
	FldGetAttributes(fldp, &fa);
	fa.underlined=val;
	FldSetAttributes(fldp, &fa);
	FldDrawField(fldp);
}
/*******************************************
 
    gets a record

    returns an error or 0 if O.K.

********************************************/
int VCPDbGetRecx(int idx, char *dat, char *fname, long lnr)
{
	VoidHand hnd;

	if (VCPINTOpenFlag==FALSE){
		VCPDbErrorFlag=VCPINTDBNOTOPEN;
		VCPINTDbErrorDisplay(fname, lnr);
		return(VCPINTDBNOTOPEN);
	}

	hnd=DmQueryRecord(VCPINTDbRef, idx);
	if (hnd==0){
		VCPDbErrorFlag=VCPINTRECNOTFOUND;
		VCPINTDbErrorDisplay(fname, lnr);
		return(VCPINTRECNOTFOUND);
	}

	StrCopy(dat, MemHandleLock(hnd));

	MemHandleUnlock(hnd);
	return(0);
}
/********************************************************************
	Inserts a new record in the database

	returns 0  if successful
	otherwise return error number

	the index of the inserted record is returned in the idx param

*********************************************************************/
int VCPDbInsertRecx(UInt *idx, char *dat, char *fname, long lnr)
{
	VoidHand hnd;
	int err;
	VoidPtr lptr;

	if (VCPINTOpenFlag==FALSE){
		VCPDbErrorFlag=VCPINTDBNOTOPEN;
		VCPINTDbErrorDisplay(fname, lnr);
		return(VCPINTDBNOTOPEN);
	}

	(*idx)=65535;  /* max index, insert as last record */
	hnd=DmNewRecord (VCPINTDbRef, idx, StrLen(dat)+1);
	if (hnd==NULL){
		VCPDbErrorFlag=VCPINTCOULDNOTINSERT;
		VCPINTDbErrorDisplay(fname, lnr);
		return(VCPINTCOULDNOTINSERT);
	}
	lptr=MemHandleLock(hnd);
	err=DmWriteCheck(lptr, 0, StrLen(dat)+1);
	if (err!=0){
		VCPDbErrorFlag=err;
		VCPINTDbErrorDisplay(fname, lnr);
		return(err);
	}
	DmWrite(lptr, 0,  dat, StrLen(dat)+1);
	MemHandleUnlock(hnd);
	DmReleaseRecord(VCPINTDbRef, *idx, TRUE);
	return(0);
}
/**************************************************
	Deletes a database
	
	This function accepts a name. At first we
	have to get the local ID for the database.
	If the db is not found, an internal V.C.P.
	error is returned.

***************************************************/
int VCPDbDeleteDBx(char *dbname, char *fname, long lnr)
{
	int err;
	LocalID id;

	/* get the local id of the database */
	id=DmFindDatabase (0, dbname);
	if (id==0){
		VCPDbErrorFlag=VCPINTDBNOTFOUND;
		VCPINTDbErrorDisplay(fname, lnr);
		return(VCPINTDBNOTFOUND);
	}

	err=DmDeleteDatabase (0, id);
	if (err>0){
		VCPDbErrorFlag=err;
		VCPINTDbErrorDisplay(fname, lnr);
	}
	return(err);
}
/***********************************************
 
    Create a database

    dbname	= name of the database
    dbcreator	= 4 byte CreatorID of the application
    dbtype	= 4 byte Type of DB, e.g. data

	returns 0 if o.k.
************************************************/
int VCPDbCreateDBx(char *dbname, ULong dbcreatorid, ULong dbtype,
                   char *fname, long lnr){
int rc;

	rc=DmCreateDatabase(0, dbname, dbcreatorid, dbtype, FALSE);
	if (rc>0){
		VCPDbErrorFlag=rc;
		VCPINTDbErrorDisplay(fname, lnr);
	}
	return(rc);
}
/*******************************************************************
	opens a database

      	dbname  	= name of database, e.g., "TESTDB"
	mode		= open mode
			dmModeReadWrite Read-write access.
			dmModeReadOnly  Read-only access.
			dmModeLeaveOpen Leave database open even after
					application quits.
			dmModeExclusive Dont let anyone else open it.

	returns 0 on success or error code

********************************************************************/
int VCPDbOpenDBx(char *dbname, UInt mode, char *fname, long lnr)
{
	DmOpenRef ref;
	LocalID	lid;
	
	if (VCPINTOpenFlag==TRUE){
		VCPDbErrorFlag=VCPINTONEDBISOPEN;
		VCPINTDbErrorDisplay(fname, lnr);
		return(VCPINTONEDBISOPEN);
	}
	lid=DmFindDatabase(0, dbname);
	if (lid==0){
		VCPDbErrorFlag=VCPINTUNSUCCESSFULLOPEN;
		VCPINTDbErrorDisplay(fname, lnr);
		return(VCPINTUNSUCCESSFULLOPEN);
	}
	ref=DmOpenDatabase(0, lid, mode);
	if (ref==0){
		VCPDbErrorFlag=VCPINTUNSUCCESSFULLOPEN;
		VCPINTDbErrorDisplay(fname, lnr);
		return(VCPINTUNSUCCESSFULLOPEN);
	}
	VCPINTDbRef=ref;
	VCPINTOpenFlag=TRUE;
	return(0);
}
/*******************************************************************
	closes a database
********************************************************************/
int VCPDbCloseDBx(char *fname, long lnr)
{
	int rc;
	
	if (VCPINTOpenFlag==FALSE){
		VCPDbErrorFlag=VCPINTDBNOTOPEN;
		VCPINTDbErrorDisplay(fname, lnr);
		return(VCPINTDBNOTOPEN);
	}
	rc=DmCloseDatabase (VCPINTDbRef);
	if (rc>0){
		VCPDbErrorFlag=rc;
		VCPINTDbErrorDisplay(fname, lnr);
	}
	VCPINTOpenFlag=FALSE;
	return(rc);
}

