/* merge.c */

#pragma pack(2)

#include <Pilot.h>

#include "life.h"

#define MAX_TAPES 9

short merge(cell_t *tape, short length, short num_tapes, cell_t *adjust,
    cell_t *out, short max_outlen, Boolean *rules)
{
    short offsets[MAX_TAPES];

    struct {
	cell_t cell;
	short tape_no;
    } heads[MAX_TAPES], *p, *q;

    short outlen = 0;
    short i;

    cell_t current, top;

    for (i = 0; i < num_tapes; ++i) {
	offsets[i] = 0;
	heads[i].cell = *tape + adjust[i];
	heads[i].tape_no = i;
    }

    current = heads[0].cell;

    while (num_tapes > 0) {
	short tape_no = heads[0].tape_no;
	short offset = ++offsets[tape_no];
	if (offset < length) {
	    cell_t cell = tape[offset] + adjust[tape_no];
	    p = heads;
	    q = heads + num_tapes - 1;
	    for ( ; p < q && p[1].cell < cell; ++p) {
		*p = p[1];
	    }
	    p->cell = cell;
	    p->tape_no = tape_no;
	} else {
	    --num_tapes;
	    p = heads;
	    q = heads + num_tapes;
	    for ( ; p < q; ++p) {
		*p = p[1];
	    }
	}

	if (num_tapes > 0
	 && (top = heads[0].cell, CELL_EQ(top, current))) {
	    current += GET_COUNT(top);
	} else {
	    if (rules == NULL) {
		if (outlen < max_outlen) {
		    out[outlen++] = current;
		} else {
		    return -1;
		}
	    } else if (rules[GET_COUNT(current)]) {
		if (outlen < max_outlen) {
		    out[outlen++] = CLEAR_COUNT(current) + DEFAULT_COUNT;
		} else {
		    return -1;
		}
	    }

	    current = top;
	}
    }

    return outlen;
}
