/* load.c */

#pragma pack(2)

#include <Pilot.h>

#include "life.h"

#define IsDigit(c) ((c) >= '0' && (c) <= '9')

static Boolean get_num(char *str, long strlen, long *pos, short *value)
{
    Boolean neg = false;

    if (*pos + 1 >= strlen || str[*pos] != ' ') {
	return false;
    }

    if (str[++*pos] == '-') {
	neg = true;
	if (++*pos >= strlen) {
	    return false;
	}
    }

    if (! IsDigit(str[*pos])) {
	return false;
    }

    *value = 0;
    do {
	*value = *value * 10 + str[*pos] - '0';
    } while (++*pos < strlen && IsDigit(str[*pos]));

    if (neg) {
	*value = - *value;
    }

    return true;
}

short load(cell_t *tape, short maxlen, char *str, long strlen)
{
    long pos = 0;
    short length = 0;
    short x = 0, y = 0;

    while (pos < strlen) {
	if (str[pos] == '#') {
	    short new_x, new_y;
	    if ((++pos < strlen && (str[pos] == 'P' || str[pos] == 'p'))
	     && ++pos < strlen
	     && get_num(str, strlen, &pos, &new_x)
	     && get_num(str, strlen, &pos, &new_y)) {
		x = new_x;
		y = new_y;
	    }
	} else if (str[pos] == '.' || str[pos] == '*') {
	    short x1 = x;
	    while (pos < strlen && (str[pos] == '.' || str[pos] == '*')) {
		if (str[pos] == '*') {
		    if (length < maxlen) {
			cell_t cell = CELL(x1, y);
			short i;
			for (i = length; i > 0 && tape[i - 1] > cell; --i) {}
			if (i == 0 || (i > 0 && tape[i - 1] != cell)) {
			    if (i < length) {
				MemMove(tape + i + 1, tape + i,
					sizeof(cell_t) * (length - i));
			    }
			    tape[i] = cell;
			    ++length;
			}
		    } else {
			return -1;
		    }
		}
		++x1;
		++pos;
	    }
	    ++y;
	}

	while (pos < strlen && str[pos++] != '\n') {}
    }

    return length;
}
