/* life.h */

typedef long cell_t;

#define DEFAULT_COUNT 2
#define CELL(x, y) ((((cell_t) (x) + (1 << 12)) << 5) \
		  + (((cell_t) (y) + (1 << 12)) << 18) + DEFAULT_COUNT)
#define GET_X(cell) ((((cell) >>  5) & 0x1fff) - (1 << 12))
#define GET_Y(cell) ((((cell) >> 18) & 0x1fff) - (1 << 12))
#define GET_COUNT(cell) ((cell) & 0x1f)
#define CLEAR_COUNT(cell) ((cell) & ~0x1f)
#define CELL_EQ(cell1, cell2) (CLEAR_COUNT((cell1) ^ (cell2)) == 0)

/* from load.c */

short load(cell_t *tape, short maxlen, char *str, long strlen);

/* from merge.c */

short merge(cell_t *tape, short length, short num_tapes, cell_t *adjust,
    cell_t *out, short max_outlen, Boolean *rules);
