/* PilotLib.c */

#pragma pack(2)

#include <Pilot.h>

#include "PilotLib.h"

/*
 * functions
 */

VoidPtr GetObjectPtr(Word objectId)
{
    FormPtr form;

    form = FrmGetActiveForm();
    return FrmGetObjectPtr(form, FrmGetObjectIndex(form, objectId));
}

FieldPtr GetFocusObjectPtr()
{
    FormPtr form;
    Word focus;

    form = FrmGetActiveForm();
    focus = FrmGetFocus(form);
    return (focus == noFocus) ? NULL : FrmGetObjectPtr(form, focus);
}

void SetFieldNumber(FieldPtr field, CharPtr str, long number)
{
    StrIToA(str, number);
    FldSetTextPtr(field, str);
    FldDrawField(field);
}

Word FindCategory(DmOpenRef dbRef, CharPtr categoryName, Boolean caseless)
{
    char name[dmCategoryLength];
    Word i;

    for (i = 0; i < dmRecNumCategories; ++i) {
	CategoryGetName(dbRef, i, name);
	if ((caseless && StrCaselessCompare(name, categoryName) == 0)
	 || (! caseless && StrCompare(name, categoryName) ==0)) {
	    break;
	}
    }
    return i;
}
