/*
Dotty V1.0 - The Dots Game (Les Petits Carreaux)
Copyright (C) 1998 Franois Pessaux (francois.pessaux@inria.fr)


This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


/* game.c */
Boolean GameEventHandler (EventPtr) ;
void DisplayIntro (void) ;

/* init.c */
void init_game_data (void) ;
void clear_game (void) ;
void InitApplication (void) ;

/* gfx.c */
void init_game_display (void) ;
void cell_turn_on (unsigned char, unsigned char, unsigned char) ;
void edge_turn_on (unsigned char) ;
void refresh_whole_game_display (void) ;

/* edge.c */
void edge_get_groups (struct edge*, unsigned char*, unsigned char*) ;


/* kernel.c */
void merge_group (struct edge*) ;
void scan_grid (void) ;
void handle_human_play (short, short) ;
void handle_computer_think (void) ;
void send_computer_play_event (void) ;
void display_score (void) ;

/* cell.c */
unsigned char cell_weight (struct cell*) ;
unsigned char cell_open_side (struct cell*) ;

/* options.c */
Boolean OptionEventHandler (EventPtr) ;
