/*
Dotty V1.0 - The Dots Game (Les Petits Carreaux)
Copyright (C) 1998 Franois Pessaux (francois.pessaux@inria.fr)


This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>

#include "bool.h"
#include "dots.h"
#include "protos.h"


extern unsigned char game_width ;
extern unsigned char game_height ;
extern boolean human_turn ;
extern unsigned char pilot_plays_first ;
extern unsigned char remaining_cells ;

extern struct vertex *vertices ;
extern struct edge *edges ;
extern struct cell *cells ;
extern unsigned char n_vertices, n_edges, n_cells ;
extern BitmapPtr  computer_bitmap ;
extern BitmapPtr  human_bitmap ;



void EndApplication (void)
{
  struct dotprefs dotprefs ;

  /* Don't free  bitmaps, they belongs to the database !!! */

  /* Save preferences */
  dotprefs.pref_game_width = game_width  ;
  dotprefs.pref_game_height = game_height ;
  dotprefs.pref_pilot_plays_first = pilot_plays_first ;
  PrefSetAppPreferencesV10 (dotAppId, 0, &dotprefs, sizeof (struct dotprefs));

  /* If a game is alive, save it */
  { DmOpenRef dots_db ;
  UInt index ;
  VoidHand handle ;
  VoidPtr record ;

  DmCreateDatabase (0, dotsStateName, dotAppId, 'Data', FALSE) ;
  dots_db = DmOpenDatabase (0, DmFindDatabase (0, dotsStateName),
			    dmModeReadWrite) ;
  /* Game width */
  index = 0 ;
  handle = DmNewRecord (dots_db, &index, sizeof (unsigned char)) ;
  record = MemHandleLock (handle) ;
  DmWrite (record, 0, (VoidPtr*)&game_width, sizeof (unsigned char)) ;
  MemHandleUnlock (handle) ;
  DmReleaseRecord (dots_db, index, FALSE) ;
  /* Game height */
  index = 1 ;
  handle = DmNewRecord (dots_db, &index, sizeof (unsigned char)) ;
  record = MemHandleLock (handle) ;
  DmWrite (record, 0, (VoidPtr*)&game_height, sizeof (unsigned char)) ;
  MemHandleUnlock (handle) ;
  DmReleaseRecord (dots_db, index, FALSE) ;
  /* Player turn */
  index = 2 ;
  handle = DmNewRecord (dots_db, &index, sizeof (boolean)) ;
  record = MemHandleLock (handle) ;
  DmWrite (record, 0, (VoidPtr*)&human_turn, sizeof (boolean)) ;
  MemHandleUnlock (handle) ;
  DmReleaseRecord (dots_db, index, FALSE) ;
  /* Vertices */
  index = 3 ;
  handle = DmNewRecord (dots_db, &index, n_vertices * sizeof (struct vertex)) ;
  record = MemHandleLock (handle) ;
  DmWrite (record, 0, (VoidPtr*)vertices, n_vertices*sizeof (struct vertex)) ;
  MemHandleUnlock (handle) ;
  DmReleaseRecord (dots_db, index, FALSE) ;
  /* Edges */
  index = 4 ;
  handle = DmNewRecord (dots_db, &index, n_edges * sizeof (struct edge)) ;
  record = MemHandleLock (handle) ;
  DmWrite (record, 0, (VoidPtr*)edges, n_edges * sizeof (struct edge)) ;
  MemHandleUnlock (handle) ;
  DmReleaseRecord (dots_db, index, FALSE) ;
  /* Cells */
  index = 5 ;
  handle = DmNewRecord (dots_db, &index, n_cells * sizeof (struct cell)) ;
  record = MemHandleLock (handle) ;
  DmWrite (record, 0, (VoidPtr*)cells, n_cells * sizeof (struct cell)) ;
  MemHandleUnlock (handle) ;
  DmReleaseRecord (dots_db, index, FALSE) ;
  /* Remaining Cells */
  index = 6 ;
  handle = DmNewRecord (dots_db, &index, sizeof (unsigned char)) ;
  record = MemHandleLock (handle) ;
  DmWrite (record, 0, (VoidPtr*)&remaining_cells, sizeof (unsigned char)) ;
  MemHandleUnlock (handle) ;
  DmReleaseRecord (dots_db, index, FALSE) ;

  /* Close the database */
  DmCloseDatabase (dots_db) ;
  }

  /* Must free game data structure */
  MemPtrFree (vertices) ;
  MemPtrFree (edges) ;
  MemPtrFree (cells) ;
}
