#include <PLAppl.h>
#include <PLButton.h>
#include <PLString.h>
#include <PLList.h>
#include <PLField.h>

#include "resource.h"

class SampApp
  : public PApplication,
    public PFormHandler
{
  public:
    SampApp();
    virtual ~SampApp() {}

  private:
    virtual Boolean command(PCmdEvt&);

  private:
    PList listbox;
    PField left, right;
    PButton doo, dont;
};

SampApp::SampApp()
  : PApplication(kidfMainForm),
    listbox(this, kidcListbox),
    left(this,  kidtField1, kidsbScroll1),
    right(this, kidtField2), /* spot the difference ? */
    doo(this, kidcDo),
    dont(this, kidcDont)
{
  doo.text("Left");
  dont.text("Attach");
  left.text("This text is\nfar too long\nto fit in\nthe four lines\n"
            "that are shown\non the screen");
  right.text("The scrollbar is not attached!"); /* see docs!! */
  listbox.add("");
  listbox.add("Try to delete some text");
  listbox.add("from the left field,");
  listbox.add("until it fits!");
  handleFor(this);
}

Boolean SampApp::command(PCmdEvt& ev)
{
  switch (ev.id())
  {
    case kidcDo:
      listbox.add(left.text()).refresh();
      return(true);
    case kidcDont:
      right.attachScrollbar(kidsbScroll2);
      right.text("Now add a few lines").refresh();
      return(true);
    default:
      return(false);
  }
}

DWord PilotMain(Word cmd, Ptr /* cmdPBP */ , Word /* launchFlags */)
{
  if (cmd == sysAppLaunchCmdNormalLaunch)
  {
    PCLInit(APPID);
    SampApp mainAppl;

    mainAppl.run();
  }
  return(0);
}
