#include <PLAppl.h>
#include <PLList.h>

#include "prefs.h"
#include "prefdb.h"

class PrefAppl : public PApplication, public PFormHandler
{
  public:
    PrefAppl();
    virtual ~PrefAppl();
    PList prefList;

  private:
    void showPrefs();

  private:
    virtual Boolean command(PCmdEvt& e);
    virtual Boolean key(PKeyEvt& k);

  private:
    Preferences* prefs_;
};

PrefAppl::PrefAppl()
  : PApplication(kidfMainForm, evtWaitForever, false),
    prefList(this, kidlPrefs), prefs_(0)
{
  prefs_ = new Preferences(true);
  if (prefs_ == 0)
    PForm::msgBox(kidaError, "No Memory");
  showPrefs();
  handleFor(this);
}

PrefAppl::~PrefAppl()
{
  if (prefs_ != 0)
    delete prefs_;
}

void PrefAppl::showPrefs()
{
  int s = prefList.ind();
  prefList.removeAll();
  if (prefs_ == 0)
    return;
  for (UInt i = 0; i < prefs_->num(); i++)
    prefList.add(prefs_->desc(i));
  if (s >= prefList.count())
    s = prefList.count() - 1;
  prefList.ind(s).showItem(s).refresh();
}

Boolean PrefAppl::command(PCmdEvt& e)
{
  switch (e.id())
  {
    case kidmDelete:
    case kidcDelete:
    {
      if (prefs_ == 0 || prefList.ind() == -1)
        return(true);
      int sel = PForm::msgBox(kidaMessage,
                              "really delete", 
                              prefList.text(), "?");
      if (sel)
      {
        prefs_->del(prefList.text());
        showPrefs();
      }
      return(true);
    }

    case kidcSaved:
    {
      if (prefs_ != 0)
        delete prefs_;
      prefs_ = new Preferences(e.on());
      if (prefs_ == 0)
        PForm::msgBox(kidaError, "No Memory");
      showPrefs();
      return(true);
    }

    case kidmAbout:
    case kidmInfo:
    case kidcInfo:
      help(kidsAbout);
      return(true);

    default:
      return(false);
  }
}

Boolean PrefAppl::key(PKeyEvt& k)
{
  if (k.pgUp())
  {
    prefList.scroll(up);
  }
  else if (k.pgDown())
  {
    prefList.scroll(down);
  }
  else
    return(false);
  return(true);
}

DWord PilotMain(Word cmd, Ptr /* cmdPBP */ , Word /* launchFlags */)
{
  if (cmd == sysAppLaunchCmdNormalLaunch)
  {
    PCLInit(APPID);
    PrefAppl mainAppl;

    mainAppl.run();
  }
  return(0);
}
