#include <PLAppl.h>
#include <PLString.h>
#include <PLList.h>

#include "resource.h"

///////////////////////////////////////////////////////////////////////
//                                                                   //
// This shows several things:                                        //
//    1. How to use an application (or form as it's own handler)     //
//       (see class SampApp)                                         //
//    2. How to use a separate handler for a form without            //
//       subclassing PForm                                           //
//    3. How to subclass a PControl (or, in this case a PList)       //
//                                                                   //
///////////////////////////////////////////////////////////////////////

class PopUpHandler : public PFormHandler
{
  public:
    PopUpHandler(PForm* frm) : form(frm) { handleFor(form); }
  private:
    virtual Boolean command(PCmdEvt&);
    PForm* form;
};

class SampList : public PList
{
  public:
    SampList(PForm* parent, Word id) : PList(parent, id) {}
    virtual ~SampList() {}
  protected:
    void loadInit();
};

class SampApp
  : public PApplication,
    public PFormHandler
{
  public:
    SampApp();
    virtual ~SampApp() {}

  private:
    virtual Boolean command(PCmdEvt&);
    virtual Boolean key(PKeyEvt&);
  private:
    SampList listbox;
    PForm popUpForm;
    PopUpHandler popUpHandler;
};

SampApp::SampApp()
 : PApplication(kidfMainForm),
   listbox(this, kidcListbox),
   popUpForm(kidfSecondForm),
   popUpHandler(&popUpForm)
{
  handleFor(this);
  listbox.add("Press 'Do' several times");
  listbox.add("Then use PageUp/Down keys.");
  listbox.add("").add("And try the menus!");
}

void SampList::loadInit()
{
  /* Be sure to call the parent classes loadInit() !!!! */
  PList::loadInit();
  ind(count()-1);
}

Boolean SampApp::key(PKeyEvt& ev)
{
  if (ev.pgUp())
  {
    listbox.scroll(up);
    return(true);
  }
  if (ev.pgDown())
  {
    listbox.scroll(down);
    return(true);
  }
  return(false);
}

Boolean SampApp::command(PCmdEvt& ev)
{
  switch (ev.id())
  {
    case kidcDo:
      listbox.add("Doo bee doo").refresh();
      return(true);
    case kidcDont:
      listbox.removeAll().add("Doo bee don't").refresh();
      return(true);
    case kidcCheckbox:
    {
      PString state = ev.on() ? "" : "not ";
      listbox.add("Checkbox is " + state + "checked.").refresh();
      return(true);
    }
    case kidmAbout:
      FrmHelp(kidsAbout);
      return(true);
    case kidmPopUp:
      popUpForm.popUp();
      return(true);

    default:
      return(false);
  }
}

Boolean PopUpHandler::command(PCmdEvt& ev)
{
  switch (ev.id())
  {
    case kidcSecondOK:
    {
      PForm conf(kidfConfirm);
      Word retCode = conf.doDialog();
      if (retCode == kidcConfOK)
        /* do something useful here! */
        form->returnTo();
      return(true);
    }
    case kidcSecondCancel:
      form->returnTo();
      return(true);
    default:
      return(false);
  }
}

DWord PilotMain(Word cmd, Ptr /* cmdPBP */ , Word /* launchFlags */)
{
  if (cmd == sysAppLaunchCmdNormalLaunch)
  {
    PCLInit(APPID);
    SampApp mainAppl;

    mainAppl.run();
  }
  return(0);
}
