#include <PLAppl.h>
#include <PLButton.h>
#include <PLString.h>
#include <PLList.h>
#include <PLField.h>

#include "resource.h"

class SampApp
  : public PApplication,
    public PFormHandler
{
  public:
    SampApp();
    virtual ~SampApp() {}

  private:
    virtual Boolean command(PCmdEvt&);

  private:
    PList listbox;
    PField left, right;
    PButton doo, dont;
};

SampApp::SampApp()
  : PApplication(kidfMainForm),
    listbox(this, kidcListbox),
    left(this,  kidtField1),
    right(this, kidtField2),
    doo(this, kidcDo),
    dont(this, kidcDont)
{
  doo.text("Left");
  dont.text("Right");
  left.text("two\nlines");
  right.text("I filled something in for you!\n"
             "                                "
             "reserved space                  "
             "still                   reserved",
             true); /* see docs!! */
  listbox.removeAll();
  handleFor(this);
}

Boolean SampApp::command(PCmdEvt& ev)
{
  switch (ev.id())
  {
    case kidcDo:
      listbox.add(left.text()).refresh();
      left.grabFocus();
      return(true);
    case kidcDont:
      listbox.add(right.text()).refresh();
      right.grabFocus();
      return(true);
    case kidcCheckbox: /* Let's get down to business! */
    {
      PString state("Checkbox is ");
      state += ev.on() ? "on" : "off";
      /* Retrieve and lock the handle (dont' forget error checking!) */
      Handle h = right.handle();
      char* p = (char*) MemHandleLock((VoidHand) h);
      /* Manipulate the data, but be careful! */
      MemSet(p, right.text().len(), ' ');
      MemMove(p, state, state.len());
      /* release the handle */
      MemHandleUnlock((VoidHand) h);
      /* and redraw the field */
      right.refresh();
    }
    default:
      return(false);
  }
}

DWord PilotMain(Word cmd, Ptr /* cmdPBP */ , Word /* launchFlags */)
{
  if (cmd == sysAppLaunchCmdNormalLaunch)
  {
    PCLInit(APPID);
    SampApp mainAppl;

    mainAppl.run();
  }
  return(0);
}
