#include <PLAppl.h>
#include <PLList.h>
#include <PLButton.h>

#include "resource.h"

class SampAppl : public PApplication, public PFormHandler
{
  public:
    SampAppl();
    virtual ~SampAppl();
    PList prefList;
    PList popList;
    PButton info;
    PButton data;
    PButton popTrig;
    PButton check;
    PButton trig;

  private:
    virtual Boolean command(PCmdEvt& e);
    virtual Boolean key(PKeyEvt& k);
};

SampAppl::SampAppl()
  : PApplication(kidfMainForm, evtWaitForever, false)
    , prefList(this, kidlPrefs)
    , popList(this, kidlPop)
    , info(this, kidcInfo)
    , data(this, kidcData)
    , popTrig(this, kidptPop)
    , check(this, kidcCheck)
    , trig(this, kidcDelete)
{
  handleFor(this);
  popTrig.text("Hello");
  info.val(true);
}

SampAppl::~SampAppl()
{
}

Boolean SampAppl::command(PCmdEvt& e)
{
  switch (e.id())
  {
    case kidcDelete:
      popTrig.click();
      return(true);

    case kidcInfo:
    case kidcData:
      prefList
        .add(popTrig.text() + " " + 
             popTrig.val()  + " " + check.val()    + " " + info.val())
        .refresh();
        this->label(kidtText, popList.text());
      return(true);

    case kidcSelect:
    {
      PForm dlg(kidfSelect);
      Word ret = PSystem::sysMessage("Select!");
      prefList.add(PString(ret)).refresh();
      return(true);
    }

    case kidcBitm:
      check.val(!check.val()).click();
      return(true);

    case kidcCheck:
    {
      trig.enable(check.val());
      PString state("Trig is ");
      state += trig.enabled() ? "" : "not ";
      state += "enabled";
      prefList.add(state).refresh();
      return(true);
    }
    case kidmDelete:
    case kidmAbout:
    case kidmInfo:
      help(kidsAbout);
      return(true);
    default:
      return(false);
  }
}

Boolean SampAppl::key(PKeyEvt& k)
{
  if (k.pgUp())
  {
    prefList.scroll(up);
  }
  else if (k.pgDown())
  {
    prefList.scroll(down);
  }
  else
    return(false);
  return(true);
}

DWord PilotMain(Word cmd, Ptr /* cmdPBP */ , Word /* launchFlags */)
{
  if (cmd == sysAppLaunchCmdNormalLaunch)
  {
    PCLInit(APPID);
    SampAppl mainAppl;

    mainAppl.run();
  }
  return(0);
}
