#ifndef _FLPSTUB_H
#define _FLPSTUB_H

#include <SysAll.h>

#define _DONT_USE_FP_TRAPS_ 1
#include <NewFloatMgr.h>

#ifdef __cplusplus
  extern "C" {
#endif

#define F_DSPTCH(num) asm("moveq.l %0,%%d2" : : "i" (num) : "d2")

#define FlpDoubleRet1(pre, name, pType, em) \
  void Trp##name(FlpDouble*, pType)\
     SYS_TRAP(sysTrapFlp##em##Dispatch);\
  inline FlpDouble pre##name(pType p)\
    { FlpDouble __fd;\
      F_DSPTCH(sysFloat##em##name);Trp##name(&__fd, p);\
      return(__fd); }
#define FlpDoubleRet2(pre, name, pType1, pType2, em) \
  void Trp##name(FlpDouble*, pType1, pType2)\
     SYS_TRAP(sysTrapFlp##em##Dispatch);\
  inline FlpDouble pre##name(pType1 p1, pType2 p2)\
    { FlpDouble __fd;\
      F_DSPTCH(sysFloat##em##name);Trp##name(&__fd, p1, p2);\
      return(__fd); }

#define FlpShortRet1(pre, name, pType, em) \
  Short Trp##name(FlpDouble*, pType)\
    SYS_TRAP(sysTrapFlp##em##Dispatch);\
  inline Short pre##name(pType p)\
    { F_DSPTCH(sysFloat##em##name);return(Trp##name(p)); }
#define FlpShortRet2(pre, name, pType1, pType2, em) \
  Short Trp##name(pType1, pType2)\
    SYS_TRAP(sysTrapFlp##em##Dispatch);\
  inline Short pre##name(pType1 p1, pType2 p2)\
    { F_DSPTCH(sysFloat##em##name);return(Trp##name(p1, p2));}

#define FlpLongRet2(pre, name, pType1, pType2, em) \
  Long Trp##name(pType1, pType2)\
    SYS_TRAP(sysTrapFlp##em##Dispatch);\
  inline Long pre##name(pType1 p1, pType2 p2)\
    { F_DSPTCH(sysFloat##em##name);return(Trp##name(p1, p2));}

FlpDoubleRet1(Flp, AToF,  char*,);
FlpShortRet2 (Flp, FToA,  FlpDouble, char*,);
FlpDoubleRet2(   ,_d_add, FlpDouble, FlpDouble,Em);
FlpDoubleRet2(   ,_d_sub, FlpDouble, FlpDouble,Em);
FlpDoubleRet2(   ,_d_mul, FlpDouble, FlpDouble,Em);
FlpDoubleRet2(   ,_d_div, FlpDouble, FlpDouble,Em);

#ifdef __cplusplus
  }
#endif

#endif /* _FLPSTUB_H */
