#ifndef _PLUI_H
#define _PLUI_H

#include <PLSys.h>
#include <PLBase.h>
#include <PLString.h>
#include <PLEvt.h>

/**********************************************************************/
/* UI classes                                                         */
/**********************************************************************/

/*--------------------------------------------------------------------*/
/* form                                                               */
/*--------------------------------------------------------------------*/
class PControl;
class PForm;

class PFormLowLevelHandler : public PFormHandler
{
  public:
    PFormLowLevelHandler(PForm* form);

  private:
    virtual Boolean dispatch(EventPtr e, const PWin hwnd);
    PForm* form_;
};

class PForm
  : public PBaseObj
{
  friend class PFormLowLevelHandler;

  public:
    PForm(Word formId);
    ~PForm();
    PForm& popUp();
    PForm& goTo();
    Word   doDialog(); 
    PForm& returnTo(const PForm* form = 0);
    PForm& showObj(PControl& ctl);
    PForm& hideObj(PControl& ctl);
    inline FormPtr frmPtr() const { return(frmPtr_); }
    inline Word    id()  const { return(frmId_); }
    PForm& addChild(PControl* ctl);
    PForm& updateForm(Word code = frmRedrawUpdateCode);
    PString label(Word labelId);
    PForm&  label(Word labelId, const PString& text);
    static Word msgBox(Word alertId,
                       const PString& s1 = "",
                       const PString& s2 = "",
                       const PString& s3 = "");
    static void help(Word helpId);
  private:
    PForm& init(FormPtr ptr);
    PForm& exit();

  private:
    class Child
    {
      public:
        PControl* ctl;
        Child*    next;
    };
    PFormLowLevelHandler lowLevelHandler;
    Word frmId_;
    FormPtr frmPtr_;
    Child* children_;
};

/*--------------------------------------------------------------------*/
/*                                                                    */
/*--------------------------------------------------------------------*/
class PControl
  : public PBaseObj
{
  friend class PForm;

  public:
    PControl(PForm *parent, Word id);

  public:
    virtual Boolean usable()  = 0;
    virtual Boolean enabled() = 0;
    virtual Boolean visible() = 0;

    virtual PControl& show(Boolean show);
    inline  virtual PControl& show() { return(show(true)); }
    inline  virtual PControl& hide() { return(show(false)); }
    inline  virtual PControl& usable(Boolean) { return(*this); }
    inline  virtual PControl& enable(Boolean) { return(*this); }
    virtual PControl& refresh() = 0;
    inline Word id() { return(id_); }
    SWord idx();

  protected:
    PControl(PForm* parent, VoidPtr objPtr);
    VoidPtr objPtr();
    inline PForm*  parent() { return(parent_); }
    inline FormPtr frmPtr() { return(parent_->frmPtr()); }
    virtual void loadInit() {};
    virtual void unloadExit() {};

  private:
    PControl(const PControl&);
    PControl& operator =(const PControl&);

  private:
    Word id_;
    SWord idx_;
    PForm* parent_;
    VoidPtr objPtr_;
};

#endif /* _PLUI_H */
