#ifndef _PLTABLE_H
#define _PLTABLE_H

#include <PLSys.h>
#include <PLBase.h>
#include <PLString.h>
#include <PLUI.h>
#include <PLField.h>

class PTable : public PControl
{
  public:
    PTable(PForm * parent, Word id, int rows, int cols,
           Boolean hasScrollbar = false);
    virtual ~PTable();
  public:
    PTable& scroll(enum directions, short count = 0);
    inline TablePtr tablePtr() { return((TablePtr) objPtr()); }
    PTable& ins(int before);
    PTable& itemStyle(int row, int col, TableItemStyleType style);
    PTable& itemStyle(int col, TableItemStyleType style);
    int     itemInt(int row, int col);
    PTable& itemPtr(int row, int col, VoidPtr p);
    PTable& itemInt(int row, int col, int i);
    PField* currentField();
    PTable& setFocus(int row, int col);
    PTable& activateLoad(Boolean active = true);
    PTable& activateSave(Boolean active = true);
    inline int cols() const { return(cols_); }
    inline int rows() const { return(rows_); }
    virtual inline Boolean loadData(Word /* row */, Word /* col */,
                             Boolean /* editable */,
                             VoidHand* /* dataH */,
                             WordPtr /* offs */, WordPtr /* size */)
      { return(false); }
    virtual inline Boolean saveData(Word /* row */, Word /* col */)
      { return(false); }

  /* From PControl */
  public:
    virtual PTable& refresh();

  protected:
    virtual void loadInit();
    virtual void unloadExit();

  private:
    static Err loadCallback(TablePtr table, Word row, Word col,
                             Boolean editable,
                             VoidHand* data,
                             WordPtr dOffs, WordPtr dSize,
                             FieldPtr fld);
    static Boolean saveCallback(TablePtr table, Word row, Word col);
    static void addCallback(VoidPtr*, PTable*, TablePtr);
    static void addLoadCallback(PTable*, TablePtr);
    static void addSaveCallback(PTable*, TablePtr);
    void removeCallbacks(TablePtr p = 0);
    PTable(const PTable&);
    PTable& operator =(const PTable&);
    PTable& setScrollbar();
    VoidPtr addInitList(int row, int col);
    VoidPtr addInitList(int row, int col, TableItemStyleType style);
    void performInit(VoidPtr);

  private: /* should be public */
    virtual Boolean usable() { return true; }
    virtual Boolean enabled() { return true; }
    virtual Boolean visible() { return true; }

  private:
    int rows_, cols_;
    VoidPtr initList_;
    PField* currentField_;
    static VoidPtr loadCB_;
    static VoidPtr saveCB_;
};

#endif /* _PLTABLE_H */


