#ifndef _PLSYS_H
#define _PLSYS_H

#include <PLBase.h>
#include <PLString.h>

/**********************************************************************/
/* Macros (at least one)                                              */
/**********************************************************************/
#define EVER ;;
#define fatalMessage(m) _fatalMessage(__FILE__, __LINE__, m)

class PSystem : private PBaseObj
{
  public:
    static void init(char*, DWord);
    static void _fatalMessage(const char*, UInt, const char *msg)
       __attribute__ ((noreturn));
    static Word sysMessage(char* s1=0, char* s2=0, char* s3=0);
    static inline int objectCount() { return PBaseObj::objCount_; }
    static PString versionString();
    static inline Boolean initialized() { return(initialized_); }
    static int palmOSVer();
    static inline DWord   appId() { return(id_.appId_); }
    static inline PString appIdString() { return(PString(id_.appIds_)); }

  private:
    virtual inline forbidInstantiation() = 0;

  private:
    static  Boolean initialized_;
    static union AppId
    {
      DWord appId_;
      char  appIds_[5];
    } id_;
};

#define PCLInit(APPID) (\
{\
  if (PSystem::objectCount() == -1)\
    __main();\
  PSystem::init(___PCL_VERSION___, APPID);\
})

extern "C" void __main(void);

#endif /* _PLSYS_H */
