#ifndef _PLSTRING_H
#define _PLSTRING_H

#include <PLBase.h>

class PString : private PBaseObj
{
  public:
    inline PString()                 : data_(0),size_(0),len_(0) { copy(0);}
    inline PString(const char *p)    : data_(0),size_(0),len_(0) { copy(p);}
    inline PString(const PString& s) : data_(0),size_(0),len_(0) { copy(s.data_);}
    inline PString(short s)          : data_(0),size_(0),len_(0) { copy(sVal(s));}
    inline PString(int i)            : data_(0),size_(0),len_(0) { copy(sVal(i));}
    inline PString(long l)           : data_(0),size_(0),len_(0) { copy(sVal(l));}
    inline PString(unsigned i)       : data_(0),size_(0),len_(0) { copy(sVal(i));}
    inline PString(ULong l)          : data_(0),size_(0),len_(0) { copy(uVal(l));}
    inline PString(UShort s)         : data_(0),size_(0),len_(0) { copy(uVal(s));}
    inline PString(char c)           : data_(0),size_(0),len_(0) { copy(&c, 1);}
    inline PString(const void* p, int len)
      : data_(0),size_(0) { copy((const char*)p,len);}
    ~PString();

  public:
    inline operator char* () const { return(data_); }
    inline PString operator= (const PString& s)
      { copy(s.data_); return *this;}
    inline char& operator[] (int idx) { return(data_[checkedIdx(idx)]);}
    inline const char& operator[] (int idx) const
      { return((const char&) data_[checkedIdx(idx)]);}
    inline PString& operator+= (const PString& s)
      { concat((char *) s); return(*this); }
    inline PString& operator+= (const char *p)
      { concat(p); return(*this); }
    inline Boolean operator== (const char* p) const
      {  return(compare(p) == 0); }
    inline Boolean operator== (const PString& s) const
      {  return(compare((char *)s, len_) == 0); }

  public:
    inline PString& resize(int size) {strNew(*this, size);return(*this);}
    PString& copy(const char *p, int len = -1, int size = -1);
    PString& concat(const char* r, int len = -1);
    int compare(const char* p, int len = -1) const;
    int stricmp(const char* p) const;
    inline int len() const { return(len_); }

  public:
    inline long          asLong() { return(data_ == 0 ? 0 : StrAToI(data_)); }
    inline unsigned long asULong()  { return((ULong)asLong()); }
    inline int           asInt()    { return((int)asLong()); }
    inline unsigned int  asUInt()   { return((UInt)asLong()); }
    PString& d2x();
    static inline PString& d2x(const PString& s)
      { return(PString(s).d2x()); }

  private:
    static inline void strNew(PString&, int size);
    static inline void strDelete(PString&);
    char *sVal(long v);
    char *uVal(unsigned long v);
    int  strFatal(const PString& msg) const;
    inline int checkedIdx(int i) const
      { return ((i<0 || i>size_) ?
                   strFatal("String index out of bounds") :  i);}

  private:
    char *data_;
    int  size_;
    int  len_;

};

char* PStrCopy(char*, const PString&);
inline char* PStrCopy(PString& l, const char* r)
  { l.copy(r); return((char*)l); }

inline const PString operator+ (const PString& l, const PString& r)
  { return (PString(l) += r); }
inline const PString operator+ (const PString& l, const char* r)
  { return (PString(l) += r); }
inline const PString operator+ (const char* l, const PString& r)
  { return (PString(l) += r); }

inline Boolean operator== (const char* l, const PString& r)
  { return (r.compare(l) == 0); }
#endif /* _PLSTRING_H */
