#ifndef _PLSCROLLB_H
#define _PLSCROLLB_H

#include <PLSys.h>
#include <PLBase.h>
#include <PLUI.h>

class PScrollbar : public PControl
{
  public:
    PScrollbar(PForm * parent, Word id);
    virtual ~PScrollbar() {};

  public:
    Short minVal();
    Short maxVal();
    Short val();
    Short pageSize();
    PScrollbar& setValues(Short val, Short minV,
                          Short maxV, Short pgSz);
    inline PScrollbar& minVal(Short m) {return(setValues(-1,m,-1,-1));}
    inline PScrollbar& maxVal(Short m) {return(setValues(-1,-1,m,-1));}
    inline PScrollbar& val(Short v) {return(setValues(v,-1,-1,-1));}
    inline PScrollbar& pageSize(Short p) {return(setValues(-1,-1,-1,p));}
    inline ScrollBarPtr scrollbarPtr() { return((ScrollBarPtr) objPtr()); }
  /* From PControl */
  public:
    virtual PScrollbar& show(Boolean show = true);
    inline  virtual PScrollbar& hide() { return(show(false)); }
    virtual PScrollbar& refresh();

  protected:
    PScrollbar(const PScrollbar&);
    virtual void loadInit();

  private:
    PScrollbar& operator =(const PScrollbar&);

  private: /* should be public */
    virtual Boolean usable() { return true; };
    virtual Boolean enabled() { return true; };
    virtual Boolean visible() { return true; };

  private:
    Short min_, max_, val_, pgSz_;
};

#endif /* _PLSCROLLB_H */
