#ifndef _PLLIST_H
#define _PLLIST_H

#include <PLSys.h>
#include <PLBase.h>
#include <PLString.h>
#include <PLUI.h>

class PList : public PControl
{
  public:
    PList(PForm* parent, Word id);
    virtual ~PList();

  public:
    int    ind();
    PList& ind(int sel);
    PString text();
    PList& add(const PString& s);
    PList& ins(const PString& s, const int before);
    PList& remove(const int idx);
    PList& removeAll();
    PList& replace(const PString& s, int idx);
    inline int count() { return(numLines_); }
    PList& scroll(enum directions, short count = 0);
    PList& setTop(int idx);
    PList& showItem(int idx);
    inline ListPtr listPtr() { return((ListPtr) objPtr()); }

  /* From PControl */
  public:
    virtual PList& refresh();
    virtual PList& show(Boolean show = true);
    inline  virtual PList& hide() { return(show(false)); }
    virtual Boolean visible();
    virtual Boolean usable();
    virtual Boolean enabled();

  protected:
    virtual void loadInit();

  private: /* not applicable */
    virtual PList& usable(Boolean) {return(*this);}
    virtual PList& enable(Boolean);

  private:
    PList(const PList&);
    PList& operator =(const PList&);
    PList& grow();
    inline PList& lock();
    inline PList& unlock();

  private:
    int  numLines_;
    int  numAlloc_;
    char **pLines_;
    int  lockInd_;
};


#endif /* _PLLIST_H */
