#ifndef _PLFIELD_H
#define _PLFIELD_H

#include <PLSys.h>
#include <PLBase.h>
#include <PLString.h>
#include <PLUI.h>

class PField : public PControl
{
  friend class PFieldPSclEvtHandler;

  public:
    PField(PForm * parent, Word id,
           const Word scrollbarId,
           const PString& text = (char *) 0, Boolean keep = false);
    PField(PForm * parent, Word id,
           const PString& text = (char *) 0, Boolean keep = false);
    PField(PForm * parent, FieldPtr fieldPtr);
    virtual ~PField();
    PString text();
    PField& text(const PString& s, Boolean keep = false);
    Handle  handle();
    PField& handle(Handle h, Boolean keep = true);
    PField& attachScrollbar(const Word id);
    PField& scroll(enum directions, short count = 0);
    Word    allocated();
    inline FieldPtr fieldPtr() { return((FieldPtr) objPtr()); }
    PField& underline(Boolean u = true);
    Boolean underlined();
    PField& grabFocus(Boolean f = true);
    inline PField& releaseFocus() { return(grabFocus(false)); }

  /* From PControl */
  public:
    virtual PField& show(Boolean show = true);
    virtual PField& refresh();
    virtual Boolean usable();
    virtual PField& usable(Boolean);
    virtual Boolean enabled();
    virtual PField& enable(Boolean e = true);
    virtual Boolean visible();

  protected:
    virtual void loadInit();

  private:
    PField(const PField&);
    PField& operator =(const PField&);
    virtual void unloadExit();
    PField& setScrollbar();

  private: /* should be public */

  private:
    Handle text_;
    Boolean ownHandle_ : 1;
    Boolean keep_ : 1;
    PForm* parent_;
    VoidPtr scl_;
    VoidPtr sclHandler_;
};

#endif /* _PLFIELD_H */

