#ifndef _PLEXECPT_H
#define _PLEXECPT_H

#include <PLBase.h>

enum PExcCode
{
  ok = 0,
  noMem = 100, 
  stringError,

  doesNotHappen = 666
};

class PExc : private PBaseObj
{
  public:
    inline PExc(PExcCode cd = ok) : cd_(cd), msg_(0) {}
    PExc(const char* msg, PExcCode cd = ok);
    PExc(const PExc& e);
    inline ~PExc() { if (msg_) MemPtrFree(msg_); }
    inline PExcCode code() const { return(cd_); }
    inline const char* msg() const { return(msg_); }
  private:
    PExcCode cd_;
    char*   msg_;
};

#ifdef HANDLE_EXCEPTIONS

static inline void PLErrThrow(const char* msg, PExcCode code)
  {  throw(PExc(msg, code)); }

static inline void PLErrThrow(const PExc& e)
  {  throw(PExc(e)); }

#else

#include <PLSys.h>

static inline void PLErrThrow(const char* msg, int)
  { PSystem::fatalMessage(msg); }

static inline void PLErrThrow(const PExc& e)
  { PSystem::fatalMessage(e.msg()); }

#endif /* HANDLE_EXCEPTIONS */

#endif /* _PLEXECPT_H */
