#ifndef _PLDOUBLE_H
#define _PLDOUBLE_H

#include <PLSys.h>
#include <PLBase.h>
#include <PLString.h>

#include <flpstub.h>

class PDouble : private PBaseObj
{
  public:
    inline PDouble() {flt_.d = 0.0;}
    inline PDouble(const PDouble& f) : flt_(f.flt_) {}
    inline PDouble(const PString& s) { flt_.fd = FlpAToF(s); }
    inline PDouble(const double d) { flt_.d = d; }
    inline PDouble(const FlpDouble& fd) { flt_.fd = fd; }
  public:
    inline operator double () const { return (flt_.d); }
    inline operator FlpDouble() const { return (flt_.fd); }
    operator PString () const;
  public:
    inline PDouble& operator= (const PDouble& r)
      {flt_ = r.flt_; return(*this);}
    inline PDouble& operator+= (const PDouble& r)
      { flt_.fd = _d_add(this->flt_.fd, r.flt_.fd); return(*this); }
    inline PDouble& operator+= (const double r)
      { register FlpCompDouble rhs; rhs.d = r;
        flt_.fd = _d_add(this->flt_.fd, rhs.fd); return(*this); }
    inline PDouble& operator-= (const PDouble& r)
      { flt_.fd = _d_sub(this->flt_.fd, r.flt_.fd); return(*this); }
    inline PDouble& operator-= (const double r)
      { register FlpCompDouble rhs; rhs.d = r;
        flt_.fd = _d_sub(this->flt_.fd, rhs.fd); return(*this); }
    inline PDouble& operator*= (const PDouble& r)
      { flt_.fd = _d_mul(this->flt_.fd, r.flt_.fd); return(*this); }
    inline PDouble& operator*= (const double r)
      { register FlpCompDouble rhs; rhs.d = r;
        flt_.fd = _d_mul(this->flt_.fd, rhs.fd); return(*this); }
    inline PDouble& operator/= (const PDouble& r)
      { flt_.fd = _d_div(this->flt_.fd, r.flt_.fd); return(*this); }
    inline PDouble& operator/= (const double r)
      { register FlpCompDouble rhs; rhs.d = r;
        flt_.fd = _d_div(this->flt_.fd, rhs.fd); return(*this); }
  private:
    FlpCompDouble flt_;
};

inline PDouble operator+(const PDouble& lf, const PDouble& rf)
  { return(PDouble(lf) += rf); }
inline PDouble operator+(const PDouble& lf, const double rd)
  { return(PDouble(lf) += rd); }
inline PDouble operator+(const double ld, const PDouble& rf)
  { return(PDouble(ld) += rf); }

inline PDouble operator-(const PDouble& lf, const PDouble& rf)
  { return(PDouble(lf) -= rf); }
inline PDouble operator-(const PDouble& lf, const double rd)
  { return(PDouble(lf) -= rd); }
inline PDouble operator-(const double ld, const PDouble& rf)
  { return(PDouble(ld) -= rf); }

inline PDouble operator*(const PDouble& lf, const PDouble& rf)
  { return(PDouble(lf) *= rf); }
inline PDouble operator*(const PDouble& lf, const double rd)
  { return(PDouble(lf) *= rd); }
inline PDouble operator*(const double ld, const PDouble& rf)
  { return(PDouble(ld) *= rf); }

inline PDouble operator/(const PDouble& lf, const PDouble& rf)
  { return(PDouble(lf) /= rf); }
inline PDouble operator/(const PDouble& lf, const double rd)
  { return(PDouble(lf) /= rd); }
inline PDouble operator/(const double ld, const PDouble& rf)
  { return(PDouble(ld) /= rf); }

#endif /* _PLDOUBLE_H */

