#ifndef _PLBUTTON_H
#define _PLBUTTON_H
#include <PLUI.h>

class PButton : public PControl
{
  public:
    PButton(PForm * parent, Word id);
    virtual ~PButton() {};
    PString text();
    PButton& text(const PString& s);
    PButton& click();
    int val();
    PButton& val(int v);

  public: /* from PControl */
    virtual Boolean  usable();
    virtual PButton& usable(Boolean);
    virtual Boolean  enabled();
    virtual PButton& enable(Boolean e = true);
    virtual Boolean visible();
    virtual PButton& refresh();

  protected:
    virtual void loadInit();

  private:
    PButton(const PButton&);
    PButton& operator =(const PButton&);
    inline ControlPtr buttonPtr() { return((ControlPtr) objPtr()); }

  private:
    char *text_;
    int val_;
};
#endif /* _PLBUTTON_H */

