#ifndef _PLBASE_H_
#define _PLBASE_H_

#include <Common.h>
#include <System/SysAll.h>
#include <System/DataMgr.h>
#include <System/StringMgr.h>
#include <UI/UIAll.h>

#include <PLBuiltin.h> /* to override some builtin functions */

/**********************************************************************/
/* some (very few defines)                                            */
/**********************************************************************/
#define ___PCL_VERSION___ "0.2.0 (c) T. Johler 1997"

/**********************************************************************/
/* prototype PilotMain as extern "C"                                  */
/**********************************************************************/
extern "C" DWord PilotMain(Word cmd, Ptr cmdPBP , Word launchFlags);

/**********************************************************************/
/* Base classes                                                       */
/**********************************************************************/
class PBaseObj
{
  friend class PSystem;

  public:
    inline PBaseObj() { objCount_++; }
    inline PBaseObj(const PBaseObj&) { objCount_++; }
    inline ~PBaseObj() { objCount_--; }

  private:
    static int objCount_;
};

class PPoint : private PBaseObj
{
  public:
    PPoint(SWord x = 0, SWord y = 0) { cx_ = x; cy_ = y; }

  private:
    SWord cx_;
    SWord cy_;
};

class PRect : private PBaseObj
{
  public:
    PRect() : tL_(), bR_() {};
    PRect(PPoint tl, PPoint br) { tL_ = tl; bR_ = br; }
    PRect(SWord xtl, SWord ytl, SWord xbr, SWord ybr)
      : tL_(xtl, ytl), bR_(xbr, ybr) {}

  private:
    PPoint tL_;
    PPoint bR_;
};

class PHandle : private PBaseObj
{
  public:
    PHandle() { hnd_ = hndCnt_++; }
    PHandle(const PHandle& o) { hnd_ = o.hnd_; }
    PHandle& operator =(const PHandle& r) { hnd_ = r.hnd_; return *this; }
    Boolean operator ==(const PHandle& r) { return (hnd_ == r.hnd_); }
    friend Boolean operator ==(const PHandle& l, const PHandle& r);
    long debugValue() const { return(hnd_); }

  public:
    static const PHandle nullHandle;

  private:
    PHandle(long init) { hnd_ = init; hndCnt_ = init + 1;}
    long hnd_;
    static long hndCnt_;
};

inline Boolean operator ==(const PHandle& l, const PHandle& r)
                       { return (l.hnd_ == r.hnd_); }

class PWindow : private PBaseObj 
{
  public:
    friend class PControl;

    PWindow();

    PHandle& handle() { return(hwnd_); }
    operator PHandle() { return(hwnd_); }

  private:
    PWindow(const PWindow&);
    PWindow& operator =(const PHandle&);
    PHandle hwnd_;
    PRect bounds_;
};

#define ___COPYRIGHT___ __Thomas_Johlers_Pilot_Class_Library__
#define ___VERPOS___ 5

#endif /* _PLBASE_H */
