/* FRAME-WORK FOR PALMDEV-STUDIO
 *
 * From the GNU-SDK Tutorial
 *
 */

#pragma pack(2)
#include 	<Common.h>
#include 	<System/SysAll.h>
#include 	<UI/UIAll.h>
#include 	"***PNAME***"


#define 	AppID    '***CID***'

static int StartApplication(void);
static void EventLoop(void);
static void StopApplication(void);
static Boolean frmMainEH(EventPtr event);

DWord  PilotMain (Word cmd, Ptr cmdPBP, Word launchFlags)
{
	int error;
	if (cmd == sysAppLaunchCmdNormalLaunch)
 	{
		error = StartApplication();	// Application start code
		if (error) return error;
		EventLoop();	// Event loop
		StopApplication ();	// Application stop code
	}
	return 0;
}

static int StartApplication(void)
{
	FrmGotoForm(frmMain);
}

static void EventLoop(void)
{
	short err;
	int formID;
	FormPtr form;
	EventType event;

	do
	{
		EvtGetEvent(&event, 200);

	if (SysHandleEvent(&event)) continue;
	if (MenuHandleEvent((void *)0, &event, &err)) continue;

	if (event.eType == frmLoadEvent)
		{
		formID = event.data.frmLoad.formID;
		form = FrmInitForm(formID);
		FrmSetActiveForm(form);
		switch (formID) 
			{  
			case frmMain:
				FrmSetEventHandler(form, (FormEventHandlerPtr) frmMainEH);
				break;  
			}
		} FrmDispatchEvent(&event);
	} while(event.eType != appStopEvent);
}

static void StopApplication(void)
{
	//Insert stop code here
}

static Boolean frmMainEH(EventPtr event)
{
	FormPtr   form;
	int       handled = 0;

	switch (event->eType) 
	{
		case frmOpenEvent:
			form = FrmGetActiveForm();
			FrmDrawForm(form);
			handled = 1;
		break;
		case ctlSelectEvent:  // A control button was pressed and released.
			if (event->data.ctlEnter.controlID == cmdClose)
			{  	
				handled = 1;
			}
		break;
		case nilEvent:
			handled = 1;
		break;
	}
	return handled;
}