/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.InlineView;
import javax.swing.text.html.StyleSheet;

public class ParagraphView
extends javax.swing.text.ParagraphView {
    private AttributeSet attr;
    private StyleSheet.BoxPainter painter;

    public ParagraphView(Element element) {
        super(element);
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
        this.painter = styleSheet.getBoxPainter(this.attr);
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        sizeRequirements = super.calculateMinorAxisRequirements(n, sizeRequirements);
        float f = 0.0f;
        int n2 = this.getLayoutViewCount();
        int n3 = 0;
        while (n3 < n2) {
            View view = this.getLayoutView(n3);
            if (view instanceof InlineView) {
                float f2 = ((InlineView)view).getLongestWordSpan();
                f = Math.max(f2, f);
            } else {
                f = Math.max(view.getMinimumSpan(n), f);
            }
            ++n3;
        }
        sizeRequirements.minimum = (int)f;
        sizeRequirements.preferred = Math.max(sizeRequirements.minimum, sizeRequirements.preferred);
        sizeRequirements.maximum = Math.max(sizeRequirements.preferred, sizeRequirements.maximum);
        return sizeRequirements;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
        super.changedUpdate(documentEvent, shape, viewFactory);
    }

    public AttributeSet getAttributes() {
        return this.attr;
    }

    public float getMaximumSpan(int n) {
        if (!this.isVisible()) {
            return 0.0f;
        }
        return super.getMaximumSpan(n);
    }

    public float getMinimumSpan(int n) {
        if (!this.isVisible()) {
            return 0.0f;
        }
        return super.getMinimumSpan(n);
    }

    public float getPreferredSpan(int n) {
        if (!this.isVisible()) {
            return 0.0f;
        }
        return super.getPreferredSpan(n);
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }

    public boolean isVisible() {
        View view;
        int n = this.getLayoutViewCount() - 1;
        int n2 = 0;
        while (n2 < n) {
            view = this.getLayoutView(n2);
            if (view.isVisible()) {
                return true;
            }
            ++n2;
        }
        return n <= 0 || (view = this.getLayoutView(n)).getEndOffset() - view.getStartOffset() != 1;
    }

    public void setParent(View view) {
        super.setParent(view);
        this.setPropertiesFromAttributes();
    }

    protected void setPropertiesFromAttributes() {
        if (this.attr != null) {
            this.setInsets((short)this.painter.getInset(1, this), (short)this.painter.getInset(2, this), (short)this.painter.getInset(3, this), (short)this.painter.getInset(4, this));
            Object object = this.attr.getAttribute(CSS.Attribute.TEXT_ALIGN);
            if (object != null) {
                String string = object.toString();
                if (string.equals("left")) {
                    this.setJustification(0);
                } else if (string.equals("center")) {
                    this.setJustification(1);
                } else if (string.equals("right")) {
                    this.setJustification(2);
                } else if (string.equals("justify")) {
                    this.setJustification(3);
                }
            }
        }
    }
}

