/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.util;

import com.seanreilly.util.HTTPCommunicator;
import com.seanreilly.util.StreamTable;
import com.seanreilly.util.StreamVector;
import com.seanreilly.util.VersionVerifierCallback;
import java.net.URLEncoder;
import java.util.Enumeration;

public class VersionVerifier
extends Thread {
    String[] newFeatures = new String[0];
    double newVersion = 0.0;
    double thisVersion = 0.0;
    String message = "";
    private String hostname;
    private String productName;
    private VersionVerifierCallback callback;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            String string = HTTPCommunicator.getPageForRef(this.hostname, 80, "/products/versions/" + URLEncoder.encode(this.productName));
            StreamTable streamTable = new StreamTable();
            streamTable.readFrom(string);
            this.newVersion = new Double((String)streamTable.get("current_version"));
            if (this.newVersion <= this.thisVersion) {
                this.callback.userHasCurrentVersion();
                return;
            }
            string = (String)streamTable.get("message");
            String string2 = (String)streamTable.get("version_description");
            StreamVector streamVector = (StreamVector)streamTable.get("new_features");
            this.newFeatures = new String[streamVector.size()];
            int n = 0;
            Enumeration enumeration = streamVector.elements();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    this.callback.userHasOldVersion(string, string2, this.newFeatures);
                    return;
                }
                this.newFeatures[n] = "" + enumeration.nextElement();
                ++n;
            }
        }
        catch (Exception exception) {
            this.callback.errorCheckingVersion(exception.toString());
            return;
        }
    }

    public VersionVerifier(String string, String string2, VersionVerifierCallback versionVerifierCallback, double d) {
        this.hostname = string;
        this.thisVersion = d;
        this.productName = string2;
        this.callback = versionVerifierCallback;
        if (this.hostname != null && this.productName != null && this.callback != null) {
            this.start();
        }
    }
}

