/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.util;

import com.seanreilly.util.StringEncodingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamUtil {
    public static char getNonWhitespace(InputStream inputStream) throws IOException {
        char c;
        while ((c = (char)inputStream.read()) == ' ' || c == '\n' || c == '\r' || c == ',' || c == ';' || c == '\t') {
        }
        return c;
    }

    public static String readUndelimitedString(InputStream inputStream, char c) throws IOException {
        StringBuffer stringBuffer = new StringBuffer("" + c);
        char c2;
        while ((c2 = (char)inputStream.read()) != ' ' && c2 != '\n' && c2 != '\r' && c2 != ',' && c2 != ';' && c2 != '\uffffffff' && c2 != '=' && c2 != '\t') {
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String readString(InputStream inputStream) throws StringEncodingException, IOException {
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl = false;
        while (true) {
            char c;
            if ((c = (char)inputStream.read()) == '\uffffffff') {
                throw new StringEncodingException("Unexpected End of String");
            }
            if (c == '\\') {
                c = (char)inputStream.read();
                if (c == 'n') {
                    stringBuffer.append('\n');
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            if (c == '\"') {
                return stringBuffer.toString();
            }
            stringBuffer.append(c);
        }
    }

    public static String encodeString(String string) {
        StringBuffer stringBuffer = new StringBuffer("\"");
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\"' || c == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            ++n2;
        }
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    public static void writeString(String string, OutputStream outputStream) throws IOException {
        int n = string.length();
        outputStream.write(34);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\"') {
                outputStream.write(92);
            }
            outputStream.write(c);
            ++n2;
        }
        outputStream.write(34);
    }
}

